<?php
/**
* Header Template
*
* Here we setup all logic and XHTML that is required for the header section of all screens.
*
* @package WooFramework
* @subpackage Template
*/
$pix_guest = get_user_by( 'login', 'user_customizer' );
?>
<!DOCTYPE html>
<html class="noIE" <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<?php if(garden_pix_get_option('garden_pix_responsive','1')):?>
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
<?php endif?>
<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
<?php  $garden_pix_options = get_option('garden_pix_general_settings'); ?>
<?php if(garden_pix_get_option('garden_pix_favicon','')):?>
<link rel="shortcut icon" href="<?php echo esc_url($garden_pix_options['garden_pix_favicon']) ?>" />
<?php elseif ( function_exists( 'has_site_icon' ) && has_site_icon() ) :
	wp_site_icon ();
	  endif?>
<?php if ( is_singular() ) wp_enqueue_script( 'comment-reply' ); ?>
<?php $class = get_post_type() == 'portfolio' && !is_archive() ? 'single-portfolio sticky' : ''; ?>
<?php wp_head(); ?>
</head>
<body  <?php body_class($class); ?>   >





<?php 
	$color_sheme = isset($post->ID) && $post->ID>0 && get_post_meta($post->ID, 'color_sheme', 1) != '' ? get_post_meta($post->ID, 'color_sheme', 1) : garden_pix_get_option('garden_pix_color_sheme','color1');
	$header_type = isset($post->ID) && $post->ID>0 && get_post_meta($post->ID, 'header_type', 1) != '' ? get_post_meta($post->ID, 'header_type', 1) : garden_pix_get_option('garden_pix_header_type','layout-header1');
	$header_sticky = garden_pix_get_option('garden_pix_header_sticky','sticky');
	$page_layout = isset($post->ID) && $post->ID>0 && get_post_meta($post->ID, 'page_layout', 1) != '' ? get_post_meta($post->ID, 'page_layout', 1) : garden_pix_get_option('garden_pix_page_layout','layout-wide');
?>
	<div data-header-top="300" data-header="<?php echo esc_attr($header_sticky);?>" class="layout-theme <?php echo esc_attr($color_sheme);?> <?php echo esc_attr($header_type);?> <?php echo esc_attr($page_layout);?> animated-css">
<?php 
	if ( is_object($pix_guest) && $pix_guest->user_login == 'user_customizer' ){
		if (garden_pix_get_option('garden_pix_color_switcher','0')) { 
			require_once(get_template_directory() .'/template-parts/header/color_switcher.php');
		}
	}
	
	if( (garden_pix_get_option('garden_pix_loader','1') == 1 && is_front_page()) || garden_pix_get_option('garden_pix_loader','1') == 2){
		echo '<div id="page-preloader"><span class="spinner"></span></div>';
	}

	if($header_type == 'header3'){
		require_once(get_template_directory() .'/template-parts/header/header_type_3.php');
	}elseif($header_type == 'header2'){
		require_once(get_template_directory() .'/template-parts/header/header_type_2.php');
	}else{
		require_once(get_template_directory() .'/template-parts/header/header_type_1.php');
	}

	if (!is_page_template('fullwidth.php')){
		require_once(get_template_directory() .'/template-parts/header/header_bgimage.php'); 
	} 
?>

<!--#content-->
<div class="content" id="content">

<!-- HEADER -->
<?php if (!is_page_template('under-construction.php')):?>
<?php endif; ?>
