<?php
/**
 * The template for registering metabox.
 *
 * @package GardenPix
 * @since 1.0
 */
if(function_exists('pixtheme_portfolio_register')) {
    add_filter('rwmb_meta_boxes', 'garden_pix_register_meta_boxes');
}
add_filter( 'walker_nav_menu_start_el', 'garden_pix_one_page_nav_walker', 10, 4 );
//add_filter( 'pre_get_posts', 'garden_pix_SearchFilter' );

function garden_pix_register_meta_boxes( $meta_boxes ) {

    $meta_boxes[] = array(

        'id' => 'product_options',
        'title' => esc_html__( 'Additional Title', 'Garden' ),
        'pages' => array( 'portfolio', 'post', 'page', 'product'),
        'context' => 'normal',
        'priority' => 'high',
        'fields' => array(

            array(
                'name'    => esc_html__( 'Text', 'Garden' ),
                'id'      => "add_title",
                'desc'  => "",
                'type'    => 'text',
                'std'   => ''
            ),
            array(
                'name'    => esc_html__( 'Description', 'Garden' ),
                'id'      => "add_title_desc",
                'desc'  => "",
                'type'    => 'textarea',
                'std'   => ''
            ),

        )
    );


    $meta_boxes[] = array(
        'id' => 'post_types',
        'title' => esc_html__( 'Portfolio Option', 'Garden' ),
        'pages' => array( 'portfolio' ),
        'context' => 'normal',
        'priority' => 'high',
        'autosave' => true,
        'fields' => array(
            array(
                'name'     => esc_html__( 'Post Types', 'Garden' ),
                'id'       => "post_types_select",
                'type'     => 'select',
                'desc' => 'Select post types',
                'options'  => array(
                    'image' => 'Image',
                    'video' => 'Video',
                )
            ),
            array(
                'name' => esc_html__( 'Post Type For Image', 'Garden' ),
                'id'   => "post_image",
                'type' => 'file_advanced',
                'desc' => "Upload post type image for your post.",
                'max_file_uploads' => 4,
                'mime_type' => 'image,application,audio,video',
            ),
            array(
                'name'  => esc_html__( 'Post Type For Video', 'Garden' ),
                'id'    => 'post_video_href',
                'type'  => 'text',
                'desc' => 'Enter video link eg (http://youtu.be/DoRMzGR7ZDA)'
            ),
            array(
                'name' => esc_html__( '.', 'Garden' ),
                'id'   => "post_video_width",
                'type' => 'slider',
                'desc' => esc_html__('Range video width', 'Garden'),
                'suffix' => esc_html__( ' px', 'Garden' ),
                'js_options' => array(
                    'min'   => 100,
                    'max'   => 2000,
                    'step'  => 10,
                ),
            ),
            array(
                'name' => esc_html__( '.', 'Garden' ),
                'id'   => "post_video_height",
                'type' => 'slider',
                'desc' => esc_html__('Range video height', 'Garden'),
                'suffix' => esc_html__( ' px', 'Garden' ),
                'js_options' => array(
                    'min'   => 100,
                    'max'   => 1000,
                    'step'  => 5,
                ),
            ),
        )
    );

    $meta_boxes[] = array(

        'id' => 'portfolio_page_options',
        'title' => esc_html__( 'Portfolio Options', 'Garden' ),
        'pages' => array( 'page' ),
        'context' => 'normal',
        'priority' => 'low',
        'fields' => array(

            array(
                'name'    => esc_html__( 'Categories not to show', 'Garden' ),
                'id'      => "portfolio_page_categories_not",
                'desc'  => esc_html__( "Select the categories that you wish not to dispaly on this portfolio page.", 'Garden' ),
                'type'    => 'taxonomy',
                'options' => array(
                    'taxonomy' => 'portfolio_category',
                    'type' => 'checkbox_list'
                )
            )

        )
    );

    $meta_boxes[] = array(

        'id' => 'post_format',
        'title' => esc_html__( 'Post Format Options', 'Garden' ),
        'post_types' => array( 'post' ),
        'context' => 'normal',
        'priority' => 'low',
        'fields' => array(
            array(
                'name' => esc_html__('Post Standared:', 'Garden' ),
                'id'   => "post_standared",
                'type' => 'file_advanced',
                'max_file_uploads' => 4,
                'mime_type' => 'application,audio,video',
            ),
            array(
                'name' => esc_html__('Post Gallery:','Garden'),
                'id'   => "post_gallery",
                'type' => 'plupload_image',
                'max_file_uploads' => 25,
            ),
            array(
                'name'  => esc_html__('Quote Source:', 'Garden'),
                'id'    => "post_quote_source",
                'desc'  => '',
                'type'  => 'text',
                'std'   => '',
            ),
            array(
                'name'  => esc_html__('Quote Content:', 'Garden'),
                'id'    => "post_quote_content",
                'desc'  => '',
                'type'  => 'textarea',
                'std'   => '',
            ),
            array(
                'name'  => esc_html__('Video','Garden'),
                'id'    => "post_video",
                'desc'  => 'Video URL',
                'type'  => 'textarea',
                'std'   => '',
            )
        )

    );

    $meta_boxes[] = array(

        'id' => 'blog_page_options',
        'title' => esc_html__( 'Blog Options', 'Garden' ),
        'pages' => array( 'page' ),
        'context' => 'normal',
        'priority' => 'low',
        'fields' => array(

            array(
                'name'    => esc_html__( 'Post Per Page', 'Garden' ),
                'id'      => "blog_post_per_page",
                'desc'  => 'Enter number of Post to Show on Page',
                'type'    => 'text',
                'std'   => esc_html__( '5', 'Garden' )
            ),
            array(
                'name'    => esc_html__( 'Categories not to show', 'Garden' ),
                'id'      => "blog_page_categories_not",
                'desc'  => esc_html__( "Select the categories that you wish not to dispaly on this blog page.", 'Garden' ),
                'type'    => 'taxonomy',
                'options' => array(
                    'taxonomy' => 'category',
                    'type' => 'checkbox_list'
                )
            )

        )
    );

    return $meta_boxes;
}

function garden_pix_one_page_nav_walker($output, $item, $depth, $args) {

    if ( is_object($item) && has_nav_menu( 'primary' ) ) {  // Exectue only when it's in menu items

        $home_childs = array();  // Default value for home children

        $home_id = garden_pix_get_home_ID();

        if ( !empty($home_id ) && $depth == '0' ) {  // If home page was set

            $pages = get_pages( 'child_of=' . $home_id );
            foreach ($pages as $child) {  // Store all the child pages included in Homepage
                array_push( $home_childs, $child->ID );
            }


        }

        // If menu item's page is included in home page or menu item points to Homepage (frontpage)
        if ( in_array( $item->object_id , $home_childs ) || $item->url === garden_pix_get_home_front_page_url() ) {

            if ( $item->url === garden_pix_get_home_front_page_url() && !is_page_template('template-home.php') ) {  // Detect home menu item in other pages
                $url = home_url();
                $pattern = '/(?<=href\=")[^]]+?(?=")/';
                $output = preg_replace($pattern, $url, $output);
            } else {
                $url = home_url() . '/#' . garden_pix_get_slug($item->object_id);
                $pattern = '/(?<=href\=")[^]]+?(?=")/';
                $output = preg_replace($pattern, $url, $output);
            }

        } else {  // If it's a normal link to other pages add a class to it

            $dom = new DOMDocument;
            $dom->encoding = 'utf-8';
            $dom->loadHTML( mb_convert_encoding($output, "HTML-ENTITIES", "UTF-8") );

            $dom->removeChild($dom->firstChild);  // Remove <!DOCTYPE
            $dom->replaceChild($dom->firstChild->firstChild->firstChild, $dom->firstChild); // Remove <html><body></body></html>

            $anchors = $dom->getElementsByTagName('a');
            foreach($anchors as $anchor) {
                $anchor->setAttribute('class', 'external');
            }

            $output = $dom->saveHTML();

        }

    }

    return $output;
}

function garden_pix_SearchFilter($query) {
    if ($query->is_search) {
        $query->set('post_type', 'post');
    }
    return $query;
}
