<?php
global $vc_add_css_animation;
/**
 * Force Visual Composer to initialize as "built into the theme". This will hide certain tabs under the Settings->Visual Composer page
 */
 
add_action( 'init', 'garden_pix_integrateWithVC', 200 );
function garden_pix_integrateWithVC() {

	vc_remove_element( "vc_posts_slider" );

	$allowed_html = array(
					    'a' => array(
					        'href' => array(),
					        'title' => array(),
					        'target' => array()
					    ),
					    'p' => array(),
					    'h2' => array(),
					    'div' => array(),
					);

	$args = array( 'taxonomy' => 'portfolio_category', 'hide_empty' => '0');
	$categories = get_categories($args);
	$cats = array();
	$i = 0;
	foreach($categories as $category){
		if(is_object($category)){
			if($i==0){
				$default = $category->slug;
				$i++;
			}
			$cats[$category->name] = $category->term_id;
		}
	}
	
	if ( class_exists( 'WooCommerce' ) ) {
		$args = array( 'taxonomy' => 'product_cat', 'hide_empty' => '0');
		$categories_woo = get_categories($args);
		$cats_woo = array();
		$i = 0;
		foreach($categories_woo as $category){
			if($i==0){
				$default = $category->slug;
				$i++;
			}
			$cats_woo[$category->name] = $category->term_id;
		}
	}
		
	$add_css_animation = array(
		'type' => 'dropdown',
		'heading' => esc_html__( 'CSS Animation', 'Garden' ),
		'param_name' => 'css_animation',
		'admin_label' => true,
		'value' => array(
			esc_html__( 'No', 'Garden' ) => '',
			esc_html__( 'bounce', 'Garden' ) => 'bounce',
			esc_html__( 'flash', 'Garden' ) => 'flash',
			esc_html__( 'pulse', 'Garden' ) => 'pulse',
			esc_html__( 'rubberBand', 'Garden' ) => 'rubberBand',
			esc_html__( 'shake', 'Garden' ) => 'shake',
			esc_html__( 'swing', 'Garden' ) => 'swing',
			esc_html__( 'tada', 'Garden' ) => 'tada',
			esc_html__( 'wobble', 'Garden' ) => 'wobble',
			esc_html__( 'jello', 'Garden' ) => 'jello',
			
			esc_html__( 'bounceIn', 'Garden' ) => 'bounceIn',
			esc_html__( 'bounceInDown', 'Garden' ) => 'bounceInDown',
			esc_html__( 'bounceInLeft', 'Garden' ) => 'bounceInLeft',
			esc_html__( 'bounceInRight', 'Garden' ) => 'bounceInRight',
			esc_html__( 'bounceInUp', 'Garden' ) => 'bounceInUp',
			esc_html__( 'bounceOut', 'Garden' ) => 'bounceOut',
			esc_html__( 'bounceOutDown', 'Garden' ) => 'bounceOutDown',
			esc_html__( 'bounceOutLeft', 'Garden' ) => 'bounceOutLeft',
			esc_html__( 'bounceOutRight', 'Garden' ) => 'bounceOutRight',
			esc_html__( 'bounceOutUp', 'Garden' ) => 'bounceOutUp',
			
			esc_html__( 'fadeIn', 'Garden' ) => 'fadeIn',
			esc_html__( 'fadeInDown', 'Garden' ) => 'fadeInDown',
			esc_html__( 'fadeInDownBig', 'Garden' ) => 'fadeInDownBig',
			esc_html__( 'fadeInLeft', 'Garden' ) => 'fadeInLeft',
			esc_html__( 'fadeInLeftBig', 'Garden' ) => 'fadeInLeftBig',
			esc_html__( 'fadeInRight', 'Garden' ) => 'fadeInRight',
			esc_html__( 'fadeInRightBig', 'Garden' ) => 'fadeInRightBig',
			esc_html__( 'fadeInUp', 'Garden' ) => 'fadeInUp',
			esc_html__( 'fadeInUpBig', 'Garden' ) => 'fadeInUpBig',			
			esc_html__( 'fadeOut', 'Garden' ) => 'fadeOut',
			esc_html__( 'fadeOutDown', 'Garden' ) => 'fadeOutDown',
			esc_html__( 'fadeOutDownBig', 'Garden' ) => 'fadeOutDownBig',
			esc_html__( 'fadeOutLeft', 'Garden' ) => 'fadeOutLeft',
			esc_html__( 'fadeOutLeftBig', 'Garden' ) => 'fadeOutLeftBig',
			esc_html__( 'fadeOutRight', 'Garden' ) => 'fadeOutRight',
			esc_html__( 'fadeOutRightBig', 'Garden' ) => 'fadeOutRightBig',
			esc_html__( 'fadeOutUp', 'Garden' ) => 'fadeOutUp',
			esc_html__( 'fadeOutUpBig', 'Garden' ) => 'fadeOutUpBig',
			
			esc_html__( 'flip', 'Garden' ) => 'flip',
			esc_html__( 'flipInX', 'Garden' ) => 'flipInX',
			esc_html__( 'flipInY', 'Garden' ) => 'flipInY',
			esc_html__( 'flipOutX', 'Garden' ) => 'flipOutX',
			esc_html__( 'flipOutY', 'Garden' ) => 'flipOutY',
			
			esc_html__( 'lightSpeedIn', 'Garden' ) => 'lightSpeedIn',
			esc_html__( 'lightSpeedOut', 'Garden' ) => 'lightSpeedOut',
			
			esc_html__( 'rotateIn', 'Garden' ) => 'rotateIn',
			esc_html__( 'rotateInDownLeft', 'Garden' ) => 'rotateInDownLeft',
			esc_html__( 'rotateInDownRight', 'Garden' ) => 'rotateInDownRight',
			esc_html__( 'rotateInUpLeft', 'Garden' ) => 'rotateInUpLeft',
			esc_html__( 'rotateInUpRight', 'Garden' ) => 'rotateInUpRight',			
			esc_html__( 'rotateOut', 'Garden' ) => 'rotateOut',
			esc_html__( 'rotateOutDownLeft', 'Garden' ) => 'rotateOutDownLeft',
			esc_html__( 'rotateOutDownRight', 'Garden' ) => 'rotateOutDownRight',
			esc_html__( 'rotateOutUpLeft', 'Garden' ) => 'rotateOutUpLeft',
			esc_html__( 'rotateOutUpRight', 'Garden' ) => 'rotateOutUpRight',
			
			esc_html__( 'slideInUp', 'Garden' ) => 'slideInUp',
			esc_html__( 'slideInDown', 'Garden' ) => 'slideInDown',
			esc_html__( 'slideInLeft', 'Garden' ) => 'slideInLeft',
			esc_html__( 'slideInRight', 'Garden' ) => 'slideInRight',
			esc_html__( 'slideOutUp', 'Garden' ) => 'slideOutUp',			
			esc_html__( 'slideOutDown', 'Garden' ) => 'slideOutDown',
			esc_html__( 'slideOutLeft', 'Garden' ) => 'slideOutLeft',
			esc_html__( 'slideOutRight', 'Garden' ) => 'slideOutRight',
			
			esc_html__( 'zoomIn', 'Garden' ) => 'zoomIn',
			esc_html__( 'zoomInDown', 'Garden' ) => 'zoomInDown',
			esc_html__( 'zoomInLeft', 'Garden' ) => 'zoomInLeft',
			esc_html__( 'zoomInRight', 'Garden' ) => 'zoomInRight',
			esc_html__( 'zoomInUp', 'Garden' ) => 'zoomInUp',			
			esc_html__( 'zoomOut', 'Garden' ) => 'zoomOut',
			esc_html__( 'zoomOutDown', 'Garden' ) => 'zoomOutDown',
			esc_html__( 'zoomOutLeft', 'Garden' ) => 'zoomOutLeft',
			esc_html__( 'zoomOutRight', 'Garden' ) => 'zoomOutRight',
			esc_html__( 'zoomOutUp', 'Garden' ) => 'zoomOutUp',
			
			esc_html__( 'hinge', 'Garden' ) => 'hinge',			
			esc_html__( 'rollIn', 'Garden' ) => 'rollIn',
			esc_html__( 'rollOut', 'Garden' ) => 'rollOut',
			
		),
		'description' => esc_html__( 'Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.', 'Garden' )
	);	
	
	
	$pix_libs = $pix_fonts = $pix_fonts_str = $params = $params1 = $params2 = array();

	if(function_exists('fil_init')){

		if( array_key_exists( 'vc_iconpicker-type-pixflaticon' , $GLOBALS['wp_filter']) ) {
			$pix_libs[esc_html__( 'Flaticon', 'Garden' )] = 'pixflaticon';
		}
		if( array_key_exists( 'vc_iconpicker-type-pixfontawesome' , $GLOBALS['wp_filter']) ) {
			$pix_libs[esc_html__( 'Font Awesome', 'Garden' )] = 'pixfontawesome';
		}
		if( array_key_exists( 'vc_iconpicker-type-pixelegant' , $GLOBALS['wp_filter']) ) {
			$pix_libs[esc_html__( 'Elegant', 'Garden' )] = 'pixelegant';
		}
		if( array_key_exists( 'vc_iconpicker-type-pixicomoon' , $GLOBALS['wp_filter']) ) {
			$pix_libs[esc_html__( 'Icomoon', 'Garden' )] = 'pixicomoon';
		}
		if( array_key_exists( 'vc_iconpicker-type-pixsimple' , $GLOBALS['wp_filter']) ) {
			$pix_libs[esc_html__( 'Simple', 'Garden' )] = 'pixsimple';
		}
		if( array_key_exists( 'vc_iconpicker-type-pixcustom1' , $GLOBALS['wp_filter']) ) {
			$pix_libs[esc_html__( 'Custom 1', 'Garden' )] = 'pixcustom1';
		}
		if( array_key_exists( 'vc_iconpicker-type-pixcustom2' , $GLOBALS['wp_filter']) ) {
			$pix_libs[esc_html__( 'Custom 2', 'Garden' )] = 'pixcustom2';
		}
		if( array_key_exists( 'vc_iconpicker-type-pixcustom3' , $GLOBALS['wp_filter']) ) {
			$pix_libs[esc_html__( 'Custom 3', 'Garden' )] = 'pixcustom3';
		}
		if( array_key_exists( 'vc_iconpicker-type-pixcustom4' , $GLOBALS['wp_filter']) ) {
			$pix_libs[esc_html__( 'Custom 4', 'Garden' )] = 'pixcustom4';
		}
		if( array_key_exists( 'vc_iconpicker-type-pixcustom5' , $GLOBALS['wp_filter']) ) {
			$pix_libs[esc_html__( 'Custom 5', 'Garden' )] = 'pixcustom5';
		}
		if( array_key_exists( 'vc_iconpicker-type-fontawesome' , $GLOBALS['wp_filter']) ) {
			$pix_libs[esc_html__( 'VC Font Awesome', 'Garden' )] = 'fontawesome';
		}
		if( get_option('fil_use_vc_icons') ) {
			if (array_key_exists('vc_iconpicker-type-openiconic', $GLOBALS['wp_filter'])) {
				$pix_libs[esc_html__('VC Open Iconic', 'Garden')] = 'openiconic';
			}
			if (array_key_exists('vc_iconpicker-type-typicons', $GLOBALS['wp_filter'])) {
				$pix_libs[esc_html__('VC Typicons', 'Garden')] = 'typicons';
			}
			if (array_key_exists('vc_iconpicker-type-entypo', $GLOBALS['wp_filter'])) {
				$pix_libs[esc_html__('VC Entypo', 'Garden')] = 'entypo';
			}
			if (array_key_exists('vc_iconpicker-type-linecons', $GLOBALS['wp_filter'])) {
				$pix_libs[esc_html__('VC Linecons', 'Garden')] = 'linecons';
			}
		}

		$add_icon_libs = array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Icon library', 'Garden' ),
			'param_name' => 'type',
			'value' => $pix_libs,
			'admin_label' => true,
			'description' => esc_html__( 'Select icon library.', 'Garden' ),
		);

		if( is_array($pix_libs) ){
			$pix_fonts_str[] = $add_icon_libs;

			foreach( $pix_libs as $val ){
				if($val != '')
				$pix_fonts[$val] = array(
					'type' => 'iconpicker',
					'heading' => esc_html__( 'Icon', 'Garden' ),
					'param_name' => 'icon_'.$val,
					'value' => '',
					'settings' => array(
						'emptyIcon' => true,
						'type' => $val,
						'iconsPerPage' => 4000,
					),
					'dependency' => array(
						'element' => 'type',
						'value' => $val,
					),
					'description' => esc_html__( 'Select icon from library.', 'Garden' ),
				);
				$pix_fonts_str[] = $pix_fonts[$val];
			}
		}
	}
	
	
	$attributes1 = array(
		array(
			'type' => 'dropdown',
			'heading' => "Use Section Anchor",
			'param_name' => 'panchor',
			'value' => array("No" , "Yes"),
			'description' => esc_html__( "Need Row ID. ", 'Garden' )
		),
	);
		
	$attributes2 = array(
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Padding', 'Garden' ),
			'param_name' => 'ppadding',
			'value' => array(
				esc_html__( "Both", 'Garden' ) => 'vc_row-padding-both',				
				esc_html__( "Top", 'Garden' ) => 'vc_row-padding-top',
				esc_html__( "Bottom", 'Garden' ) => 'vc_row-padding-bottom',
				esc_html__( "No Padding", 'Garden' ) => 'vc_row-no-padding',
			),
			'description' => esc_html__( 'Top, bottom, both', 'Garden' ),
			'group' => esc_html__( 'Row Options', 'Garden' ),
		),/*
		array(
			'type' => 'attach_images',
			'heading' => esc_html__( 'Background Slides', 'Garden' ),
			'param_name' => 'pbgslides',
			'description' => esc_html__( 'Add two slides to animate a background of this section', 'Garden' ),
			'group' => esc_html__( 'Row Options', 'Garden' ),
		),*/
		
		array(
			'type' => 'dropdown',
			'heading' => "Show Page Decor",
			'param_name' => 'pdecor',
			'value' => array("No" , "Yes"),
			'description' => esc_html__( "Show page decor on top.", 'Garden' ),
			'group' => esc_html__( 'Row Options', 'Garden' ),
		),	
		array(
			'type' => 'dropdown',
			'heading' => "Text Color",
			'param_name' => 'ptextcolor',
			'value' => array("Default" , "White" , "Black"),
			'description' => esc_html__( "Text Color", 'Garden' ),
			'group' => esc_html__( 'Row Options', 'Garden' ),
		),
		
		
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Row Overflow', 'Garden' ),
			'param_name' => 'bg_row_overflow',
			'value' => array(
				esc_html__( "Default", 'Garden' ) => '',				
				esc_html__( "Overflow", 'Garden' ) => 'pix-overflow',
				esc_html__( "Overflow-X", 'Garden' ) => 'pix-overflow-x',
				esc_html__( "Overflow-Y", 'Garden' ) => 'pix-overflow-y',
			),
			'description' => esc_html__( 'Select row overflow type.', 'Garden' ),
			'group' => esc_html__( 'Row Elements', 'Garden' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Elements Parallax', 'Garden' ),
			'param_name' => 'bg_pix_image_parallax',
			'value' => array(
				esc_html__( "No", 'Garden' ) => '',				
				esc_html__( "Yes", 'Garden' ) => 'pix-parallax-elements',
			),
			'description' => esc_html__( 'Use parallax for elements.', 'Garden' ),
			'group' => esc_html__( 'Row Elements', 'Garden' ),
		),
		array(
			'type' => 'attach_image',
			'heading' => esc_html__( 'Left Backgroung Image', 'Garden' ),
			'param_name' => 'bg_image_left',
			'value' => '',
			'description' => esc_html__( 'Select image from media library.', 'Garden' ),
			'group' => esc_html__( 'Row Elements', 'Garden' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => "Vertical Position",
			'param_name' => 'bg_imgl_top_bottom',
			'value' => array(
				esc_html__( "Bottom", 'Garden' ) => 'bottom',				
				esc_html__( "Top", 'Garden' ) => 'top',				
			),
			'description' => esc_html__( "Select top or bottom position", 'Garden' ),
			'dependency' => array(
				'element' => 'bg_image_left',
				'not_empty' => true,
			),
			'group' => esc_html__( 'Row Elements', 'Garden' ),
		),
		array(
			'type' => 'textfield',
			'holder' => 'div',
			'class' => '',
			'heading' => esc_html__( 'Vertical px', 'Garden' ),
			'param_name' => 'bg_imgl_vpos',
			'value' => '',
			'description' => '',
			'dependency' => array(
				'element' => 'bg_image_left',
				'not_empty' => true,
			),
			'group' => esc_html__( 'Row Elements', 'Garden' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => "Horizontal Position",
			'param_name' => 'bg_imgl_left_right',
			'value' => array(				
				esc_html__( "Left", 'Garden' ) => 'left',
				esc_html__( "Right", 'Garden' ) => 'right',
			),
			'description' => esc_html__( "Select left or right position", 'Garden' ),
			'dependency' => array(
				'element' => 'bg_image_left',
				'not_empty' => true,
			),
			'group' => esc_html__( 'Row Elements', 'Garden' ),
		),
		array(
			'type' => 'textfield',
			'holder' => 'div',
			'class' => '',
			'heading' => esc_html__( 'Horizontal px', 'Garden' ),
			'param_name' => 'bg_imgl_hpos',
			'value' => '',
			'description' => '',
			'dependency' => array(
				'element' => 'bg_image_left',
				'not_empty' => true,
			),
			'group' => esc_html__( 'Row Elements', 'Garden' ),
		),
		
		array(
			'type' => 'attach_image',
			'heading' => esc_html__( 'Right Backgroung Image', 'Garden' ),
			'param_name' => 'bg_image_right',
			'value' => '',
			'description' => esc_html__( 'Select image from media library.', 'Garden' ),
			'group' => esc_html__( 'Row Elements', 'Garden' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => "Vertical Position",
			'param_name' => 'bg_imgr_top_bottom',
			'value' => array(		
				esc_html__( "Bottom", 'Garden' ) => 'bottom',		
				esc_html__( "Top", 'Garden' ) => 'top',				
			),
			'description' => esc_html__( "Select top or bottom position", 'Garden' ),
			'dependency' => array(
				'element' => 'bg_image_right',
				'not_empty' => true,
			),
			'group' => esc_html__( 'Row Elements', 'Garden' ),
		),
		array(
			'type' => 'textfield',
			'holder' => 'div',
			'class' => '',
			'heading' => esc_html__( 'Vertical px', 'Garden' ),
			'param_name' => 'bg_imgr_vpos',
			'value' => '',
			'description' => '',
			'dependency' => array(
				'element' => 'bg_image_right',
				'not_empty' => true,
			),
			'group' => esc_html__( 'Row Elements', 'Garden' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => "Horizontal Position",
			'param_name' => 'bg_imgr_left_right',
			'value' => array(	
				esc_html__( "Right", 'Garden' ) => 'right',			
				esc_html__( "Left", 'Garden' ) => 'left',				
			),
			'description' => esc_html__( "Select left or right position", 'Garden' ),
			'dependency' => array(
				'element' => 'bg_image_right',
				'not_empty' => true,
			),
			'group' => esc_html__( 'Row Elements', 'Garden' ),
		),
		array(
			'type' => 'textfield',
			'holder' => 'div',
			'class' => '',
			'heading' => esc_html__( 'Horizontal px', 'Garden' ),
			'param_name' => 'bg_imgr_hpos',
			'value' => '',
			'description' => '',
			'dependency' => array(
				'element' => 'bg_image_right',
				'not_empty' => true,
			),
			'group' => esc_html__( 'Row Elements', 'Garden' ),
		),		
      
	);
	if(!function_exists('fil_init')){
		$attributes = array_merge($attributes1, $attributes2);
	}else{
		$attributes = array_merge($attributes1, $pix_fonts_str, $attributes2);
	}
	vc_add_params( 'vc_row', $attributes );
	
	vc_map(
		array(
			'name' => esc_html__( 'Title', 'Garden' ),
			'base' => 'block_title',
			'class' => 'pix-theme-icon',
			'category' => esc_html__( 'Templines', 'Garden'),
			'params' => array(
				array(
					'type' => 'textfield',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__( 'Title', 'Garden' ),
					'param_name' => 'title',
					'value' => esc_html__( 'I am Title', 'Garden' ),
					'description' => esc_html__( 'Title param.', 'Garden' )
				),	
				 
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Title Position', 'Garden' ),
					'param_name' => 'titlepos',
					'value' => array(
						esc_html__( 'Left', 'Garden' ) => '',
						esc_html__( 'Center', 'Garden' ) => 'title-box-center',						
						esc_html__( 'Right', 'Garden' ) => 'title-box-right',
					),
					'description' => esc_html__( 'Center, left or right', 'Garden' ),
				),	
				array(
					'type' => 'colorpicker',
					'heading' => esc_html__( 'Title Color', 'Garden' ),
					'param_name' => 'title_color',
					'value' => '',
					'description' => '',
				),	
				$add_css_animation,
				array(
					'type' => 'textarea_html',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__( 'Content', 'Garden' ),
					'param_name' => 'content',
					'value' => wp_kses( __( '<p>I am test text block. Click edit button to change this text.</p>', 'Garden' ), $allowed_html ),
					'description' => esc_html__( 'Enter your content.', 'Garden' )
				)
			)
		) 
	);
	
	if ( class_exists( 'WPBakeryShortCode' ) ) {
		class WPBakeryShortCode_Block_Title extends WPBakeryShortCode {
			
		}
	}
	
///////////////////////////////////// BOX /////////////////////////////////////	
	
	/// box_amount
	$params1 = array(
				array(
					'type' => 'textfield',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__( 'Title', 'Garden' ),
					'param_name' => 'title',
					'value' => esc_html__( 'Project', 'Garden' ),
					'description' => esc_html__( 'Title.', 'Garden' )
				),
				array(
					'type' => 'textfield',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__( 'Amount', 'Garden' ),
					'param_name' => 'amount',
					'value' => esc_html__( '999', 'Garden' ),
					'description' => esc_html__( 'Amount.', 'Garden' )
				),
			);
	$params2 = array(
				$add_css_animation,
			);
	if(!function_exists('fil_init')){
		$params = array_merge($params1, $params2);
	}else{
		$params = array_merge($params1, $pix_fonts_str, $params2);
	}
	vc_map(
		array(
			'name' => esc_html__( 'Amount Box', 'Garden' ),
			'base' => 'box_amount',
			'class' => 'pix-theme-icon',
			'category' => esc_html__( 'Templines', 'Garden'),
			'params' => $params,
		) 
	);
	if ( class_exists( 'WPBakeryShortCode' ) ) {
		class WPBakeryShortCode_Box_Amount extends WPBakeryShortCode {
			
		}
	}
		
	
	/// section_banner
	$params1 = array(
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Buttons Position', 'Garden' ),
					'param_name' => 'buttype',
					'value' => array(
						esc_html__( 'One button left', 'Garden' ) => '',
						esc_html__( 'Two buttons bottom', 'Garden' ) => 'buttom',					
					),
					'description' => '',
				),
				array(
					'type' => 'colorpicker',
					'heading' => esc_html__( 'Button Border Color', 'Garden' ),
					'param_name' => 'border_color',
					'value' => '',
					'description' => '',
				),
				array(
					'type' => 'textfield',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__( 'Title', 'Garden' ),
					'param_name' => 'title',
					'value' => esc_html__( 'Working Hours', 'Garden' ),
					'description' => esc_html__( 'Button Title', 'Garden' )
				),	
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Button Title Font Size', 'Garden' ),
					'param_name' => 'titlefont',
					'value' => array(
						esc_html__( "Default", 'Garden' ) => '',
						esc_html__( "Large", 'Garden' ) => 'very-big-circle',				
					),
					'description' => '',
				),
			);
	$params2 = array(
				array(
					'type' => 'textfield',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__( 'Description', 'Garden' ),
					'param_name' => 'but_desc',
					'value' => esc_html__( 'Our Working Hours!', 'Garden' ),
					'description' => esc_html__( 'Button description', 'Garden' )
				),
				array(
					'type' => 'vc_link',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__( 'Link', 'Garden' ),
					'param_name' => 'link',
					'value' => esc_html__( 'https:/templines.com', 'Garden' ),
					'description' => esc_html__( 'Button link', 'Garden' )
				),
				array(
					'type' => 'textfield',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__( 'Title', 'Garden' ),
					'param_name' => 'title2',
					'value' => esc_html__( 'Get In Touch NOW', 'Garden' ),
					'dependency' => array(
						'element' => 'buttype',
						'value' => 'buttom',
					),
					'description' => esc_html__( 'Button Title', 'Garden' )
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Button Title Font Size', 'Garden' ),
					'param_name' => 'titlefont2',
					'value' => array(
						esc_html__( "Default", 'Garden' ) => '',
						esc_html__( "Large", 'Garden' ) => 'very-big-circle',				
					),
					'dependency' => array(
						'element' => 'buttype',
						'value' => 'buttom',
					),
					'description' => '',
				),
				array(
					'type' => 'textfield',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__( 'Icon', 'Garden' ),
					'param_name' => 'icon2',
					'value' => '',
					'dependency' => array(
						'element' => 'buttype',
						'value' => 'buttom',
					),
					'description' => wp_kses(__( 'Add icon <a href="//fortawesome.github.io/Font-Awesome/icons/" target="_blank">See all icons</a>', 'Garden' ), $allowed_html),
				),
				array(
					'type' => 'textfield',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__( 'Description', 'Garden' ),
					'param_name' => 'but_desc2',
					'value' => esc_html__( 'Offer Friendly Service!', 'Garden' ),
					'dependency' => array(
						'element' => 'buttype',
						'value' => 'buttom',
					),
					'description' => esc_html__( 'Button description', 'Garden' )
				),
				array(
					'type' => 'vc_link',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__( 'Link', 'Garden' ),
					'param_name' => 'link2',
					'value' => esc_html__( 'https:/templines.com', 'Garden' ),
					'dependency' => array(
						'element' => 'buttype',
						'value' => 'buttom',
					),
					'description' => esc_html__( 'Button link', 'Garden' ),
				),
				$add_css_animation,
				array(
					'type' => 'textarea_html',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__( 'Content', 'Garden' ),
					'param_name' => 'content',
					'value' => wp_kses(__( '<h2>We Work Hard And Make Your Garden Beautiful</h2>
									<div>Friendly customer service staff for your all questions!</div>', 'Garden' ), $allowed_html),
					'description' => esc_html__( 'Banner Text', 'Garden' ),
				),
			);
	if(!function_exists('fil_init')){
		$params = array_merge($params1, $params2);
	}else{
		$params = array_merge($params1, $pix_fonts_str, $params2);
	}
	vc_map(
		array(
			'name' => esc_html__( 'Banner', 'Garden' ),
			'base' => 'section_banner',
			'class' => 'pix-theme-icon',
			'category' => esc_html__( 'Templines', 'Garden'),
			'params' => $params,
		) 
	);
	if ( class_exists( 'WPBakeryShortCode' ) ) {
		class WPBakeryShortCode_Section_Banner extends WPBakeryShortCode {
			
		}
	}
	
	
	/// box_icon
	$params1 = array(
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Icon Type', 'Garden' ),
					'param_name' => 'typeicon',
					'value' => array(
						esc_html__( "Simple", 'Garden' ) => '',
						esc_html__( "Round", 'Garden' ) => 'round',
						esc_html__( "Round 2", 'Garden' ) => 'round2',					
					),
					'description' => '',
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Title", 'Garden' ),
					"param_name" => "title",
					"value" => esc_html__( "I am title", 'Garden' ),
					"description" => esc_html__( "Add Title ", 'Garden' )
				),
			);
	$params2 = array(
				/*
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Icon Position', 'Garden' ),
					'param_name' => 'position',					
					'value' => array(
						esc_html__( "Left", 'Garden' ) => 'icon-left',
						esc_html__( "Right", 'Garden' ) => 'icon-right',
					),
					'dependency' => array(
						'element' => 'typeicon',
						'value' => '',
					),
					'description' => '',
				),
				*/
				array(
					'type' => 'vc_link',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__( 'Link', 'Garden' ),
					'param_name' => 'link',
					'value' => esc_html__( 'https:/templines.com', 'Garden' ),
					'description' => esc_html__( 'Button link', 'Garden' )
				),
				array(
					'type' => 'textfield',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__( 'Button Text', 'Garden' ),
					'param_name' => 'btn_text',
					'value' => '',
					'description' => '',
				),
				$add_css_animation,
				array(
					"type" => "textarea_html",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Content", 'Garden' ),
					"param_name" => "content",
					"value" => wp_kses(__( "<p>I am test text block. Click edit button to change this text.</p>", 'Garden' ), $allowed_html),
					"description" => esc_html__( "Enter your content.", 'Garden' )
				)
			);
	if(!function_exists('fil_init')){
		$params = array_merge($params1, $params2);
	}else{
		$params = array_merge($params1, $pix_fonts_str, $params2);
	}	
	vc_map( 
		array(
			"name" => esc_html__( "Icon Box", 'Garden' ),
			"base" => "box_icon",
			"class" => "pix-theme-icon",
			"category" => esc_html__( "Templines", 'Garden'),
			"params" => $params,
		)
	);
	if ( class_exists( 'WPBakeryShortCode' ) ) {
		class WPBakeryShortCode_Box_Icon extends WPBakeryShortCode {
			
		}
	}
	
	
	/// block_info_icon
	$params1 = array(
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Title", 'Garden' ),
					"param_name" => "title",
					"value" => esc_html__( "I am title", 'Garden' ),
					"description" => esc_html__( "Add Title ", 'Garden' )
				),
				array(
					'type' => 'colorpicker',
					'heading' => esc_html__( 'Button Border Color', 'Garden' ),
					'param_name' => 'border_color',
					'value' => '',
					'description' => '',
				),
			);
	$params2 = array(
				array(
					"type" => "vc_link",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Link", 'Garden' ),
					"param_name" => "link",
					"value" => '',
					"description" => esc_html__( "Info link.", 'Garden' )
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Big Info", 'Garden' ),
					"param_name" => "big_info",
					"value" => '',
					"description" => esc_html__( "Info with large font.", 'Garden' ),
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Highlighted Info 1", 'Garden' ),
					"param_name" => "c_box_info1",
					"value" => '',
					"description" => esc_html__( "Info with background.", 'Garden' ),
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Highlighted Info 2", 'Garden' ),
					"param_name" => "c_box_info2",
					"value" => '',
					"description" => esc_html__( "Info with background.", 'Garden' ),
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Highlighted Info 3", 'Garden' ),
					"param_name" => "c_box_info3",
					"value" => '',
					"description" => esc_html__( "Info with background.", 'Garden' ),
				),
				$add_css_animation,
				array(
					"type" => "textarea_html",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Info", 'Garden' ),
					"param_name" => "content", 
					"value" => wp_kses(__( "<p>I am test text block. Click edit button to change this text.</p>", 'Garden' ), $allowed_html),
					"description" => esc_html__( "Enter information.", 'Garden' )
				),
			);
	if(!function_exists('fil_init')){
		$params = array_merge($params1, $params2);
	}else{
		$params = array_merge($params1, $pix_fonts_str, $params2);
	}
	vc_map( array(
		"name" => esc_html__( "Info Icon Block", 'Garden' ),
		"base" => "block_info_icon",
		"class" => "pix-theme-icon",
		"category" => esc_html__( "Templines", 'Garden'),
		'params' => $params,
	) );
	if ( class_exists( 'WPBakeryShortCode' ) ) {
		class WPBakeryShortCode_Block_Info_Icon extends WPBakeryShortCode {
		}
	}
	////////////////////////
	
	
	vc_map(
		array(
			"name" => esc_html__( "Brand Box", 'Garden' ),
			"base" => "box_brand",
			"class" => "pix-theme-icon",
			"category" => esc_html__( "Templines", 'Garden'),
			"params" => array(				
				 array(
					'type' => 'attach_image',
					'heading' => esc_html__( 'Image', 'Garden' ),
					'param_name' => 'image',
					'value' => '',
					'description' => esc_html__( 'Select image from media library.', 'Garden' )
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "url", 'Garden' ),
					"param_name" => "url",
					"value" => esc_html__( "https://wordpress.com", 'Garden' ), 
					"description" => esc_html__( ".", 'Garden' )
				),
				$add_css_animation,		
			)
		) 
	);
	if ( class_exists( 'WPBakeryShortCode' ) ) {
		class WPBakeryShortCode_Box_Brand extends WPBakeryShortCode {
			
		}
	}	
	
	
	/// box_mailchimp
	vc_map(
		array(
			"name" => esc_html__( "Mailchimp Box", 'Garden' ),
			"base" => "box_mailchimp",
			"class" => "pix-theme-icon",
			"category" => esc_html__( "Templines", 'Garden'),
			"show_settings_on_create" => false,
			"content_element" => true,
			'params' => array(),
		) 
	);
	if ( class_exists( 'WPBakeryShortCode' ) ) {
		class WPBakeryShortCode_Box_Mailchimp extends WPBakeryShortCode {
			
		}
	}
	//////////////////////////////////////////////////////////////////////
	
		
	vc_map(
		array(
			"name" => esc_html__( "Posts Block", 'Garden' ),
			"base" => "block_posts",
			"class" => "pix-theme-icon",
			"category" => esc_html__( "Templines", 'Garden'),
			"params" => array(
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Posts Type', 'Garden' ),
					'param_name' => 'type',
					'value' => array(
						esc_html__( "Horizontal", 'Garden' ) => 3,
						esc_html__( "Vertical", 'Garden' ) => 1,					
					),
					'description' => '',
				),	
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Posts Count', 'Garden' ),
					'param_name' => 'count',
					'description' => esc_html__( 'Leave empty to display all posts.', 'Garden' )
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Carousel', 'Garden' ),
					'param_name' => 'disable_carousel',
					'value' => array(
						esc_html__('Enable', 'Garden') => 1,
						esc_html__('Disable', 'Garden') => 0,
					),
					'description' => esc_html__( 'On/off carousel', 'Garden' )
				),
				$add_css_animation,	
			)
		) 
	);
	if ( class_exists( 'WPBakeryShortCode' ) ) {
		class WPBakeryShortCode_Block_Posts extends WPBakeryShortCode {
			
		}
	}
	
	vc_map(
		array(
			"name" => esc_html__( "Flickr", 'Garden' ),
			"base" => "flickr",
			"class" => "pix-theme-icon",
			"category" => esc_html__( "Templines", 'Garden'),
			"params" => array(
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Title", 'Garden' ),
					"param_name" => "title",
					"value" => 'Flickr Feed',
					"description" => ''
				 ),
				 array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Flickr ID", 'Garden' ),
					"param_name" => "id",
					"value" => '7992704@N05',
					"description" => esc_html__( "Get your flickr ID from: //idgettr.com/", 'Garden' )
				 ),
				 array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Number of photos", 'Garden' ),
					"param_name" => "number",
					"value" => '9',
					"description" => esc_html__( "Default 9.", 'Garden' )
				 ),
				$add_css_animation,
			)
		) 
	);	
	if ( class_exists( 'WPBakeryShortCode' ) ) {
		class WPBakeryShortCode_Flickr extends WPBakeryShortCode {
			
		}
	}


	/// section_portfolio
	vc_map(
		array(
			"name" => esc_html__( "Portfolio", 'Garden' ),
			"base" => "section_portfolio",
			"class" => "pix-theme-icon",
			"category" => esc_html__( "Templines", 'Garden'),
			"params" => array(
			
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Categories', 'Garden' ),
					'param_name' => 'cats',
					'value' => $cats,
					'description' => esc_html__( 'Select categories to show', 'Garden' )
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Items Count', 'Garden' ),
					'param_name' => 'count',
					'description' => esc_html__( 'Select number images for portfolio.', 'Garden' )
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Columns Number', 'Garden' ),
					'param_name' => 'perrow',
					'value' => array(
						esc_html__( "2 Columns", 'Garden' ) => '2',
						esc_html__( "3 Columns", 'Garden' ) => '3',
						esc_html__( "4 Columns", 'Garden' ) => '4',
						esc_html__( "Tiles", 'Garden' ) => 'default',					
					),
					'description' => '',
				),
							
				$add_css_animation,			
			)
		) 
	);
	if ( class_exists( 'WPBakeryShortCode' ) ) {
		class WPBakeryShortCode_Section_Portfolio extends WPBakeryShortCode {
			
		}
	}
	////////////////////////	
	
	/// section_tabs
	vc_map( array(
		'name' => esc_html__( 'Tabs', 'Garden' ),
		'base' => 'section_tabs',
			'class' => 'pix-theme-icon', 
		'as_parent' => array('only' => 'section_tab'), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
		'content_element' => true,
		'show_settings_on_create' => false,
		'category' => esc_html__( 'Templines', 'Garden'),
		'front_enqueue_js' => get_template_directory_uri() . '/library/functions/shortcodes/shortcode.js',
		'params' => array(
			$add_css_animation,
		),
		'js_view' => 'VcColumnView', // must be added for all Containers ( or should be extended in js ). VC Dev team
	) );
	
	$params1 = array(
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Title', 'Garden' ),
					'param_name' => 'title',
					'description' => esc_html__( 'Tab title.', 'Garden' )
				),
				array(
					'type' => 'tab_id',
					'heading' => esc_html__( 'Tab ID', 'Garden' ),
					'param_name' => "tab_id",
				),
				/*			
				array(
					'type' => 'attach_image',
					'heading' => esc_html__( 'Image', 'Garden' ),
					'param_name' => 'image',
					'value' => '',
					'description' => esc_html__( 'Select image from media library.', 'Garden' )
				),
				*/
			);
	$params2 = array(
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Content Title', 'Garden' ),
					'param_name' => 'cont_title',
					'description' => esc_html__( 'short description', 'Garden' )
				),
				array(
					'type' => 'vc_link',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__( 'Link', 'Garden' ),
					'param_name' => 'link',
					'value' => esc_html__( 'https:/templines.com', 'Garden' ),
					'description' => esc_html__( 'Button link', 'Garden' )
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Button Icon', 'Garden' ),
					'param_name' => 'btn_icon',
					'value' => 'icon_documents',
					'description' => wp_kses(__( 'Add title icon. <a href="//fortawesome.github.io/Font-Awesome/icons/" target="_blank">See all icons</a>', 'Garden' ), $allowed_html),
				),
				array(
					'type' => 'textfield',
					'holder' => 'div',
					'class' => '',
					'heading' => esc_html__( 'Button Text', 'Garden' ),
					'param_name' => 'btn_text',
					'value' => '',
					'description' => esc_html__( 'Leave empty to hide the button.', 'Garden' ),
				),	
				array(
					"type" => "textarea_html",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Content", 'Garden' ),
					"param_name" => "content",
					"value" => wp_kses(__( "<p>I am test text block. Click edit button to change this text.</p>", 'Garden' ), $allowed_html),
					"description" => esc_html__( "Enter your content.", 'Garden' )
				),
			);
	if(!function_exists('fil_init')){
		$params = array_merge($params1, $params2);
	}else{
		$params = array_merge($params1, $pix_fonts_str, $params2);
	}
	vc_map( array(
		'name' => esc_html__( 'Tab', 'Garden' ),
		'base' => 'section_tab',
		'as_child' => array('only' => 'section_tabs'),
		'content_element' => true,
		'front_enqueue_js' => get_template_directory_uri() . '/library/functions/shortcodes/shortcode.js',
		'params' => $params,
		'js_view' => 'VcTabView',
		
	) );
	if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
		class WPBakeryShortCode_Section_Tabs extends WPBakeryShortCodesContainer {
		}
	}
	if ( class_exists( 'WPBakeryShortCode' ) ) {
		class WPBakeryShortCode_Section_Tab extends WPBakeryShortCode {
		}
	}
	//////////////////////////////////	
	
		
	/// box_service
	//////// Service Box ////////
	vc_map(
		array(
			"name" => esc_html__( "Service Box", 'Garden' ),
			"base" => "box_service",
			"class" => "pix-theme-icon",
			"category" => esc_html__( "Templines", 'Garden'),
			'params' => array(
				array(
					'type' => 'attach_image',
					'heading' => esc_html__( 'Image', 'Garden' ),
					'param_name' => 'image',
					'description' => esc_html__( 'Select image.', 'Garden' )
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Title', 'Garden' ),
					'param_name' => 'title',
					'description' => esc_html__( 'Title info.', 'Garden' )
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Button text', 'Garden' ),
					'param_name' => 'button_text',
					'description' => esc_html__( 'Button info text.', 'Garden' )
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Link', 'Garden' ),
					'param_name' => 'link',
					'description' => esc_html__( 'Info link.', 'Garden' )
				),
				$add_css_animation,
				array(
					"type" => "textarea_html",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Info", 'Garden' ),
					"param_name" => "content", 
					"value" => wp_kses(__( "<p>I am test text block. Click edit button to change this text.</p>", 'Garden' ), $allowed_html),
					"description" => esc_html__( "Enter information.", 'Garden' )
				),
			)
		) 
	);	
	if ( class_exists( 'WPBakeryShortCode' ) ) {
		class WPBakeryShortCode_Box_Service extends WPBakeryShortCode {
			
		}
	}
	/////////////////////////////////
	
			
	//////// Carousel Reviews ////////
	vc_map( array(
		'name' => esc_html__( 'Reviews', 'Garden' ),
		'base' => 'section_reviews',
		'class' => 'pix-theme-icon', 
		'as_parent' => array('only' => 'section_review'),
		'content_element' => true,
		'show_settings_on_create' => true,
		'category' => esc_html__( 'Templines', 'Garden'),
		'front_enqueue_js' => get_template_directory_uri() . '/library/functions/shortcodes/shortcode.js',
		
		'params' => array(
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Reviews per page', 'Garden' ),
				'param_name' => 'reviews_per_page',
				'value' => array(
					esc_html__( "1", 'Garden' ) => 1,
					esc_html__( "2", 'Garden' ) => 2,
				),
				'description' => esc_html__( 'Select number of columns.', 'Garden' )
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Carousel', 'Garden' ),
				'param_name' => 'disable_carousel',
				'value' => array(
					esc_html__('Enable', 'Garden') => 1,
					esc_html__('Disable', 'Garden') => 0,
				),
				'description' => esc_html__( 'On/off carousel', 'Garden' )
			),
		),
		
		
		'js_view' => 'VcColumnView',
		
	) );
	vc_map( array(
		'name' => esc_html__( 'Review', 'Garden' ),
		'base' => 'section_review',
		'class' => 'pix-theme-icon', 
		'as_child' => array('only' => 'section_reviews'),
		'content_element' => true,
		'front_enqueue_js' => get_template_directory_uri() . '/library/functions/shortcodes/shortcode.js',
		'params' => array(
			array(
				'type' => 'attach_image',
				'heading' => esc_html__( 'Image', 'Garden' ),
				'param_name' => 'image',
				'description' => esc_html__( 'Select image.', 'Garden' )
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Name', 'Garden' ),
				'param_name' => 'title',
				'description' => esc_html__( 'Person name.', 'Garden' )
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Position', 'Garden' ),
				'param_name' => 'position',
				'description' => esc_html__( 'Text under the name.', 'Garden' )
			),
			/*
			array(
				'type' => 'vc_link',
				'heading' => esc_html__( 'Link', 'Garden' ),
				'param_name' => 'link',
				'description' => esc_html__( 'Author link.', 'Garden' )
			),
			*/
			array(
				"type" => "textarea_html",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Review Text", 'Garden' ),
				"param_name" => "content",
				"value" => wp_kses(__( "<p>I am test text block. Click edit button to change this text.</p>", 'Garden' ), $allowed_html),
				"description" => esc_html__( "Enter text.", 'Garden' )
			),
		)
	) );
	if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
		class WPBakeryShortCode_Section_Reviews extends WPBakeryShortCodesContainer {
		}
	}
	if ( class_exists( 'WPBakeryShortCode' ) ) {
		class WPBakeryShortCode_Section_Review extends WPBakeryShortCode {
		}
	}
	/////////////////////////////////	
	
	/// section_team
	//////// Our Team ////////
	vc_map( array(
		'name' => esc_html__( 'Team slider', 'Garden' ),
		'base' => 'section_team',
		'class' => 'pix-theme-icon', 
		'as_parent' => array('only' => 'section_team_member'),
		'content_element' => true,
		'show_settings_on_create' => true,
		'category' => esc_html__( 'Templines', 'Garden'),
		'params' => array(
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Carousel', 'Garden' ),
				'param_name' => 'carousel',
				'value' => array(
					esc_html__( "Enable", 'Garden' ) => 'owl-carousel enable-owl-carousel',
					esc_html__( "Disable", 'Garden' ) => 'disable-owl-carousel',
				),
				'description' => esc_html__( 'On/off carousel', 'Garden' )
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Min slides', 'Garden' ),
				'param_name' => 'min_slides',
				'description' => esc_html__( 'Min slides on page. Default 3.', 'Garden' )
			),
			
			$add_css_animation,
		),
		'js_view' => 'VcColumnView',
		
	) );
	vc_map( array(
		'name' => esc_html__( 'Team Member', 'Garden' ),
		'base' => 'section_team_member',
		'class' => 'pix-theme-icon', 
		'as_child' => array('only' => 'section_team'),
		'content_element' => true,
		'params' => array(
			array(
				'type' => 'attach_image',
				'heading' => esc_html__( 'Image', 'Garden' ),
				'param_name' => 'image',
				'description' => esc_html__( 'Select image.', 'Garden' )
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Name', 'Garden' ),
				'param_name' => 'name',
				'description' => esc_html__( 'Team member name.', 'Garden' )
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Position', 'Garden' ),
				'param_name' => 'position',
				'description' => esc_html__( 'Member position.', 'Garden' )
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Social Link 1', 'Garden' ),
				'param_name' => 'scn1',
				'description' => esc_html__( 'https://www.facebook.com/', 'Garden' )
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Social Network Icon 1', 'Garden' ),
				'param_name' => 'scn_icon1',
				'description' => wp_kses(__( 'Add icon social_facebook_circle <a href="//fortawesome.github.io/Font-Awesome/icons/" target="_blank">See all icons</a>', 'Garden' ), $allowed_html),
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Social Link 2', 'Garden' ),
				'param_name' => 'scn2',
				'description' => esc_html__( 'https://twitter.com/', 'Garden' )
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Social Network Icon 2', 'Garden' ),
				'param_name' => 'scn_icon2',
				'description' => wp_kses(__( 'Add icon social_twitter_circle <a href="//fortawesome.github.io/Font-Awesome/icons/" target="_blank">See all icons</a>', 'Garden' ), $allowed_html),
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Social Link 3', 'Garden' ),
				'param_name' => 'scn3',
				'description' => esc_html__( 'https://www.pinterest.com/', 'Garden' )
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Social Network Icon 3', 'Garden' ),
				'param_name' => 'scn_icon3',
				'description' => wp_kses(__( 'Add icon social_pinterest_circle <a href="//fortawesome.github.io/Font-Awesome/icons/" target="_blank">See all icons</a>', 'Garden' ), $allowed_html),
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Social Link 4', 'Garden' ),
				'param_name' => 'scn4',
				'description' => esc_html__( 'https://plus.google.com/', 'Garden' )
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Social Network Icon 4', 'Garden' ),
				'param_name' => 'scn_icon4',
				'description' => wp_kses(__( 'Add icon social_googleplus_circle <a href="//fortawesome.github.io/Font-Awesome/icons/" target="_blank">See all icons</a>', 'Garden' ), $allowed_html),
			),
			$add_css_animation,
			array(
				"type" => "textarea_html",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Info", 'Garden' ),
				"param_name" => "content", 
				"value" => wp_kses(__( "<p>I am test text block. Click edit button to change this text.</p>", 'Garden' ), $allowed_html),
				"description" => esc_html__( "Enter information.", 'Garden' )
			),
		)
	) );
	if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
		class WPBakeryShortCode_Section_Team extends WPBakeryShortCodesContainer {
		}
	}
	if ( class_exists( 'WPBakeryShortCode' ) ) {
		class WPBakeryShortCode_Section_Team_Member extends WPBakeryShortCode {
		}
	}
	////////////////////////
	
	
	//////// Social Buttons ////////
	vc_map( array(
		'name' => esc_html__( 'Social Buttons', 'Garden' ),
		'base' => 'socialbuts',
		'class' => 'pix-theme-icon', 
		'as_parent' => array('only' => 'socialbut'), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
		'content_element' => true,
		'show_settings_on_create' => false,
		'category' => esc_html__( 'Templines', 'Garden'),		
		'js_view' => 'VcColumnView',
		
	) );
	vc_map( array(
		'name' => esc_html__( 'Social Button', 'Garden' ),
		'base' => 'socialbut',
		'class' => 'pix-theme-icon', 
		'as_child' => array('only' => 'socialbuts'),
		'content_element' => true,
		'params' => array(
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Title', 'Garden' ),
				'param_name' => 'title',
				'description' => esc_html__( 'Social title.', 'Garden' )
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Icon', 'Garden' ),
				'param_name' => 'icon',
				'description' => wp_kses(__( 'Add social icon fa-facebook <a href="//fortawesome.github.io/Font-Awesome/icons/" target="_blank">See all icons</a>', 'Garden' ), $allowed_html),
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Link', 'Garden' ),
				'param_name' => 'link',
				'description' => esc_html__( 'Social link.', 'Garden' )
			),
			array(
				"type" => "colorpicker",
				"class" => "",
				"heading" => esc_html__( "Color", 'Garden' ),
				"param_name" => "color", 
				"description" => esc_html__( "Select bg color.", 'Garden' )
			),
		)
	) );
	if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
		class WPBakeryShortCode_Socialbuts extends WPBakeryShortCodesContainer {
		}
	}
	if ( class_exists( 'WPBakeryShortCode' ) ) {
		class WPBakeryShortCode_Socialbut extends WPBakeryShortCode {
		}
	}
	////////////////////////
	
	/// section_pricetable
	//////// Price Table ////////
	vc_map( array(
		'name' => esc_html__( 'Price Table', 'Garden' ),
		'base' => 'section_pricetable',
		'class' => 'pix-theme-icon', 
		'as_parent' => array('only' => 'section_pricecol'),
		'content_element' => true,
		'show_settings_on_create' => true,
		'category' => esc_html__( 'Templines', 'Garden'),
		'params' => array(
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Table Type', 'Garden' ),
				'param_name' => 'typetable',
				'value' => array(
					esc_html__( "Both", 'Garden' ) => '',
					esc_html__( "Monthly only", 'Garden' ) => 'monthly',
					esc_html__( "Yearly only", 'Garden' ) => 'yearly',					
				),
				'description' => '',
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Monthly', 'Garden' ),
				'param_name' => 'monthtext',
				'value' => 'Monthly',
				'description' => esc_html__( 'Change text for button', 'Garden' ),
				'dependency' => array(
					'element' => 'typetable',
					'value' => array('', 'monthly'),
				),
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Yearly', 'Garden' ),
				'param_name' => 'yeartext',
				'value' => 'Yearly', 
				'description' => esc_html__( 'Change text for button', 'Garden' ),
				'dependency' => array(
					'element' => 'typetable',
					'value' => array('', 'yearly'),
				),
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Monthly Short', 'Garden' ),
				'param_name' => 'monthshort',
				'value' => 'month',
				'description' => esc_html__( 'Change price duration', 'Garden' ),
				'dependency' => array(
					'element' => 'typetable',
					'value' => array('', 'monthly'),
				),
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Yearly Short', 'Garden' ),
				'param_name' => 'yearshort',
				'value' => 'year', 
				'description' => esc_html__( 'Change price duration', 'Garden' ),
				'dependency' => array(
					'element' => 'typetable',
					'value' => array('', 'yearly'),
				),
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Currency', 'Garden' ),
				'param_name' => 'currency',
				'value' => '$',
				'description' => esc_html__( 'Change currency', 'Garden' )
			),
		),
		'js_view' => 'VcColumnView',
		
	) );
	
	$params1 = array(
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Title', 'Garden' ),
					'param_name' => 'title',
					'description' => esc_html__( 'Column title.', 'Garden' )
				),
			);
	$params2 = array(
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Month Price', 'Garden' ),
					'param_name' => 'monthprice',
					'description' => esc_html__( 'Price for the month.', 'Garden' ),
					
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Year Price', 'Garden' ),
					'param_name' => 'yearprice',
					'description' => esc_html__( 'Price for the year.', 'Garden' ),
				),
				array(
					"type" => "checkbox",
					"class" => "",
					"heading" => esc_html__( "Is Popular", 'Garden' ),
					"param_name" => "ispopular", 
					"description" => esc_html__( "Marked if checked.", 'Garden' )
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Button Text', 'Garden' ),
					'param_name' => 'btntext',
					'description' => esc_html__( 'Button text.', 'Garden' )
				),
				array(
					'type' => 'vc_link',
					'heading' => esc_html__( 'Link', 'Garden' ),
					'param_name' => 'link',
					'description' => esc_html__( 'Item link.', 'Garden' )
				),
				array(
					"type" => "textarea_html",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Content", 'Garden' ),
					"param_name" => "content", 
					"value" => wp_kses(__( "<p>I am test text block. Click edit button to change this text.</p>", 'Garden' ), $allowed_html),
					"description" => esc_html__( "Enter information.", 'Garden' )
				),
			);
	if(!function_exists('fil_init')){
		$params = array_merge($params1, $params2);
	}else{
		$params = array_merge($params1, $pix_fonts_str, $params2);
	}
	vc_map( array(
		'name' => esc_html__( 'Price Column', 'Garden' ),
		'base' => 'section_pricecol',
		'class' => 'pix-theme-icon', 
		'as_child' => array('only' => 'section_pricetable'),
		'content_element' => true,
		'params' => $params,
	) );
	if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
		class WPBakeryShortCode_Section_Pricetable extends WPBakeryShortCodesContainer {
		}
	}
	if ( class_exists( 'WPBakeryShortCode' ) ) {
		class WPBakeryShortCode_Section_Pricecol extends WPBakeryShortCode {
		}
	}
	////////////////////////
	
if ( class_exists( 'WooCommerce' ) ) {	
	/// section_woocommerce
	//////// Woocommerce Products ////////
	vc_map(
		array(
			"name" => esc_html__( "Woocommerce Products", 'Garden' ),
			"base" => "section_woocommerce",
			"class" => "pix-theme-icon",
			"category" => esc_html__( "Templines", 'Garden'),
			"params" => array(
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Categories', 'Garden' ),
					'param_name' => 'cats',
					'value' => $cats_woo,
					'description' => esc_html__( 'Select categories to show', 'Garden' )
				),				
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Items Count', 'Garden' ),
					'param_name' => 'count',
					'description' => esc_html__( 'Select number products.', 'Garden' )
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Carousel', 'Garden' ),
					'param_name' => 'carousel',
					'value' => array(
						esc_html__( "Enable", 'Garden' ) => 'owl-carousel enable-owl-carousel',
						esc_html__( "Disable", 'Garden' ) => 'disable-owl-carousel',						
					),
					'description' => ''
				),				
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Slider Controls', 'Garden' ),
					'param_name' => 'controls',
					'value' => array(
						esc_html__( "Default", 'Garden' ) => '',
						esc_html__( "Controls Right", 'Garden' ) => 'full-width-slider-controls-right',
						esc_html__( "Controls Left", 'Garden' ) => 'full-width-slider-controls-left',
					),
					'description' => esc_html__( 'Select controls position.', 'Garden' )
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Min slides', 'Garden' ),
					'param_name' => 'min_slides',
					'description' => esc_html__( 'Min slides on page. Default 4.', 'Garden' )
				),	
				$add_css_animation,			
			)
		) 
	);
	if ( class_exists( 'WPBakeryShortCode' ) ) {
		class WPBakeryShortCode_Section_Woocommerce extends WPBakeryShortCode {
			
		}
	}
}
//} ////// <= End vc_inline

if(isset($_GET['vc_action']) && $_GET['vc_action'] == 'vc_inline'){
	wp_enqueue_style('garden-theme', get_template_directory_uri() . '/css/editor_styles.css');
}
	
}