<?php /* Template Name: Single Post */ 

$garden_pix_custom =  get_post_custom($post->ID);
$garden_pix_layout = isset ($garden_pix_custom['garden_pix_page_layout']) ? $garden_pix_custom['garden_pix_page_layout'][0] : '2';
$garden_pix_sidebar = isset ($garden_pix_custom['garden_pix_selected_sidebar'][0]) ? $garden_pix_custom['garden_pix_selected_sidebar'][0] : 'global-sidebar-1';
$garden_pix_options = get_option('garden_pix_general_settings');
?>
<?php get_header();?>

<section class="wrap-blog-content">
  <div class="container">
    <div class="row">
      <?php if ($garden_pix_layout == '3'): require_once(get_template_directory() .'/template-parts/sidebar.php'); endif?>
      <div class="col-xs-12 <?php if ($garden_pix_layout == '1'):?>  col-sm-12 col-md-12 <?php else: ?> col-sm-12 col-md-9 <?php endif?> ">
        <?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>
        
        
            <div class="info-box">
                <ul>
                    <li>
                        <span class="ef icon_profile"></span>
                        <?php the_author_posts_link(); ?>
                    </li>
                    <?php 
						if(garden_pix_get_option('garden_pix_blog_show_category', '1')){
							$categories = get_the_category($post->ID);
							if($categories){
								$output = '<li><span class="ef icon_folder-open "></span>';						
								foreach($categories as $category) {
									$output .= '<a href="'.esc_url(get_category_link( $category->term_id )).'" class=" ">'.$category->cat_name.'</a> ';
								}
								$output .= '</li>';
								echo wp_kses_post($output);
							}
						}
					?>
                    <?php if( 'open' == $post->comment_status && garden_pix_get_option('garden_pix_blog_show_comments', '1')) : ?>
                        <li><i class="ef icon_comment"></i><?php comments_popup_link( esc_html__( '0 Comment', 'Garden' ), esc_html__( '1 Comment', 'Garden' ), esc_html__( '% Comments', 'Garden' )); ?></li>
                    <?php endif?>
                </ul>
            </div>
            <h2 class="title"><?php the_title(); ?></h2>
            <div class="wrap-media">
		  <?php			
			$garden_pix_format  = get_post_format();
			$garden_pix_format = !in_array($garden_pix_format, array("quote", "gallery", "video")) ? 'standared' : $garden_pix_format;								
			get_template_part( 'template-parts/post-format-single/blog', $garden_pix_format);
		  ?>
          	</div>
            
            <?php wp_link_pages();?>
       <div class="rtd">     <?php the_content(); ?> </div>
            
            <div class="content-footer">
            <?php 
				if ( 'post' == get_post_type() ) : // Hide category and tag text for pages on Search                                   
                    if(garden_pix_get_option('garden_pix_blog_show_tag',1)){	
                        $posttags = get_the_tags($post->ID);
                        if ($posttags) {
                            $output = '<div class="tags-block">';
							$output .= '<span class="bold">'.esc_html__('Tags: ', 'Garden').'</span>';
                            foreach($posttags as $tag) {
                                $output .= '<a href="'.esc_url(get_tag_link( $tag->term_id )).'" >'.$tag->name.'</a>  ';
                            }
                            $output .= '</div>';
                            echo wp_kses_post($output);
                        }
                    }
              	endif; // End if 'post' == get_post_type()
			?>
            <?php if(garden_pix_get_option('garden_pix_blog_share',1)) echo do_shortcode('[share]'); ?>
                
            </div>
            
            <?php if(garden_pix_get_option('garden_pix_blog_show_comments',1)) : ?>
              <div class="post-comment">
                <?php comments_template(); ?>
                <?php $test = false; if ($test) {comment_form(); } ?>
              </div>
            <?php endif; ?>

        
        <?php endwhile; ?>
      </div>
      <?php if ($garden_pix_layout == '2'): require_once(get_template_directory() .'/template-parts/sidebar.php'); endif?>
    </div>
  </div>
</section>
<?php get_footer();?>
