<?php 
/*** The taxonomy for portfolio category. ***/
$garden_pix_options = get_option('garden_pix_general_settings');
$term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) ); 

?>

<?php get_header();?>

<div class="container">
    <div class="row"> 
        <section class="gallery">
        <?php 
            $description = get_term_field( 'description', $term->term_id, 'portfolio_category' ); 
            if( !is_wp_error( $description ) && $description != '' ) :    
        ?>
            <div class="container">
                <div class="row">
                    <div class="col-md-10 col-md-offset-1 col-sm-12">
                        <header class="section-header">
                            <p class="large"><?php echo wp_kses_post($description) ?></p>
                            
                        </header>
                    </div>
                </div>
            </div>
        <?php endif ?>
           
            <div id="pix-portfolio"  class="portfolio-view "  >		
                    
                <div class="">
                    <div class="isotope-frame portfolio-col-<?php echo garden_pix_get_option('garden_pix_portfolio_type','2') ?>">
                        <div class="isotope-filter isotope" >				
                                 
                        <?php
                            $portfolio = get_objects_in_term( $term->term_id, 'portfolio_category');
                            $args = array(
                                        'post_type' => 'portfolio', 
                                        'orderby' => 'menu_order',
                                        'post__in' => $portfolio,			 
                                        'order' => 'ASC'
                                    );
                                
                            $wp_query = new WP_Query( $args );
                                                            
                            if ($wp_query->have_posts()):
                                while ($wp_query->have_posts()) :
                                    $wp_query->the_post();	
                                
                                    $custom = get_post_custom($post->ID);
                                    $garden_pix_format = $custom['post_types_select'][0];						
                                    
                                    $cats = wp_get_object_terms($post->ID, 'portfolio_category');											   
                                                            
                                    if ($cats){
										$cat_slugs = '';
										$cat_href = '';
										foreach( $cats as $cat ){
											$cat_slugs .= $cat->slug . " ";
											$cat_href .= '<a href="'.esc_url(get_term_link( $cat )).'">' . wp_kses_post($cat->name) . "</a>, ";
										}
									}
                                    
                                    $link = ''; 
                                    $img_size = 'garden_pix-portfolio-thumb-col2';
                                    $thumbnail = get_the_post_thumbnail($post->ID, $img_size, array('class' => 'cover'));
                        ?>
                                    
                            <div class="isotope-item <?php echo esc_attr($cat_slugs) ?> <?php echo esc_attr($img_size) ?>" >                        
                                <div class="portfolio-image">
                                    <?php echo $thumbnail ?>
                                    <div class="slide-desc"><table><tr><td>
        <?php                             
                switch ($garden_pix_format){
					
                    case 'image':
        
                        $gallery = class_exists( 'RW_Meta_Box' ) ? rwmb_meta('post_image', 'type=image&size=full') : '';
                        $full_image = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full', false); 
                        $link = $full_image[0];
        ?>
                            <div class="detail-item">
                            	<div class="icons">
                                	<a  href="<?php echo esc_url($link) ?>" class="zoomPhoto"  rel="prettyPhoto[pp_gal_<?php echo esc_attr($post->ID) ?>]"    >
                                        <i class="icon-plus"></i>
                                    </a>
                                    <div style="position:absolute; left:-99999px;">
                                    <?php										
                                        foreach ($gallery as $key => $slide) {
                                            if($key>0) :
                                    ?>
                                            <a href="<?php echo esc_url($slide['url']) ?>" rel="prettyPhoto[pp_gal_<?php echo esc_attr($post->ID) ?>]" ><img src="<?php echo esc_url($slide['url']) ?>" width="<?php echo esc_attr($slide['width']) ?>" height="<?php echo esc_attr($slide['height']) ?>" alt="<?php echo esc_attr($slide['alt']) ?>" title="<?php echo esc_attr($slide['title']) ?>"/></a>
                                    <?php 	endif; 
                                        }
                                    ?>									
                                    </div>
                                    <a href="<?php esc_url(the_permalink(get_the_ID())) ?>"><i class="icon-info"></i></a>
                                </div>
                            </div>
                            
        <?php
                        break;
                        
                    case 'video':
        ?>
                            <div class="detail-item">
                                <h3><?php the_title() ?></h3>
                                <p><?php echo garden_pix_limit_words(get_the_excerpt(), 20) ?></p>
                            <?php
                                if ( get_post_meta( get_the_ID(), 'post_video_href', true ) !== '' ): 
                                        $video_embed_code = get_post_meta( get_the_ID(), 'post_video_href', true );
                                        $video_width = get_post_meta( get_the_ID(), 'post_video_width', true );
                                        $video_height = get_post_meta( get_the_ID(), 'post_video_height', true );
                            ?>		
                                    <a  href="<?php echo esc_url($video_embed_code.'?width='.esc_attr($video_width).'&amp;height='. esc_attr($video_height)) ?>" class="btn btn-primary btn-lg video-popup"   >
                                     <i class="fa fa-play-circle"></i>
                                    </a>
                            <?php
                                endif;
                            ?>
                            </div>
        <?php
                        break;
                        
                    default:
                        $gallery = class_exists( 'RW_Meta_Box' ) ? rwmb_meta('post_image', 'type=image&size=full') : '';
                        $full_image = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full', false); 
                        $link = $full_image[0];
        ?>
                            <div class="detail-item">
                            	<div class="icons">
                                	<a  href="<?php echo esc_url($link) ?>" class="zoomPhoto"  rel="prettyPhoto[pp_gal_<?php echo esc_attr($post->ID) ?>]"    >
                                        <i class="icon-plus"></i>
                                    </a>
                                    <div style="position:absolute; left:-99999px;">
                                    <?php										
                                        foreach ($gallery as $key => $slide) {
                                            if($key>0) :
                                    ?>
                                            <a href="<?php echo esc_url($slide['url']) ?>" rel="prettyPhoto[pp_gal_<?php echo esc_attr($post->ID) ?>]" ><img src="<?php echo esc_url($slide['url']) ?>" width="<?php echo esc_attr($slide['width']) ?>" height="<?php echo esc_attr($slide['height']) ?>" alt="<?php echo esc_attr($slide['alt']) ?>" title="<?php echo esc_attr($slide['title']) ?>"/></a>
                                    <?php 	endif; 
                                        }
                                    ?>									
                                    </div>
                                    <a href="<?php esc_url(the_permalink(get_the_ID())) ?>"><i class="icon-info"></i></a>
                                </div>
                            </div>                            
        <?php 
                        break;
                }						
        ?>	
                            </td></tr></table></div>
                        </div>
                   
                        
                    </div>
                                        
                            <?php							
                                     endwhile;
                                endif; ?>
                            
               </div>
            </div>
        </section>
    
    </div>
</div>
 
<?php get_footer();?>