<?php
/**
 * This template is for displaying part of blog.
 *
 * @package Pix-Theme
 * @since 1.0
 */
$garden_pix_format  = get_post_format();
$garden_pix_options = get_option('garden_pix_general_settings');
$custom =  get_post_custom($post->ID);
$layout = isset ($custom['_page_layout']) ? $custom['_page_layout'][0] : '1';

$garden_pix_format = !in_array($garden_pix_format, array("quote", "gallery", "video")) ? "standared" : $garden_pix_format;

$get_avatar = get_avatar(get_the_author_meta('ID'), 85);
preg_match("/src=['\"](.*?)['\"]/i", $get_avatar, $matches);
$src = !empty($matches[1]) ? $matches[1] : '';
	
?>

        <div class="wrap-post-description">
        	
            <div class="info-box">
                <ul>
                    <li>
                        <span class="ef icon_profile"></span>
                        <?php the_author_posts_link(); ?>
                    </li>
                    <?php 
						if(garden_pix_get_option('garden_pix_blog_show_category', '1')){
							$categories = get_the_category($post->ID);
							if($categories){
								$output = '<li><span class="ef icon_folder-open "></span>';						
								foreach($categories as $category) {
									$output .= '<a href="'.esc_url(get_category_link( $category->term_id )).'" class=" ">'.$category->cat_name.'</a> ';
								}
								$output .= '</li>';
								echo wp_kses_post($output);
							}
						}
					?>
                    <?php if( 'open' == $post->comment_status && garden_pix_get_option('garden_pix_blog_show_comments', '1')) : ?>
                        <li><i class="ef icon_comment"></i><?php comments_popup_link( esc_html__( '0 Comment', 'Garden' ), esc_html__( '1 Comment', 'Garden' ), esc_html__( '% Comments', 'Garden' )); ?></li>
                    <?php endif?>
                </ul>
            </div>
            <div class="blog-teaser-content rtd">
                <h2 class="title"><a href="<?php esc_url(the_permalink())?>"><?php wp_kses_post(the_title())?></a></h2>
                <?php wp_link_pages();?>
                <?php 
					if (get_option('rss_use_excerpt') == 0)
						the_content();
					else 
						echo do_shortcode(get_the_excerpt());
				?>
            </div>
            <a class="btn btn-border" href="<?php esc_url(the_permalink())?>">
                <span><?php esc_html_e('Read More', 'Garden')?></span>
            </a>
            
        </div>
