<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $image
 * @var $position
 * @var $link
 * @var $css_animation
 * Shortcode class
 * @var $this WPBakeryShortCode_Section_Review
 */
 
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$img_id = preg_replace( '/[^\d]/', '', $image );
$img_link = wp_get_attachment_image_src( $img_id, 'large' );
$img_link = $img_link[0];
$image_meta = garden_pix_wp_get_attachment($img_id);
$image_alt = $image_meta['alt'] == '' ? $image_meta['title'] : $image_meta['alt'];

			
$out = '
		<div class="quote-box">
			<div class="quote-block-2">
				<div class="quote-wrap">
					<div class="quote-photo">
						<img  alt="'.esc_attr($image_alt).'" src="'.esc_url($img_link).'">
					</div>
					<div class="text-quote">
						'.do_shortcode($content).'
					</div>
				</div>
				<span class="ef arrow_triangle-down"></span>
			</div>
			<div class="q-signature">
				<h4>'.wp_kses_post($title).'</h4>
				<div class="q-sub">'.wp_kses_post($position).'</div>
			</div>
		</div>
	';

echo $out;