<?php
/**
 * Single Product Meta
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $post, $product;

$cat_count = sizeof( get_the_terms( $post->ID, 'product_cat' ) );
$tag_count = sizeof( get_the_terms( $post->ID, 'product_tag' ) );

?>
<div class="product_meta">

	<?php do_action( 'woocommerce_product_meta_start' ); ?>

	<?php if ( wc_product_sku_enabled() && ( $product->get_sku() || $product->is_type( 'variable' ) ) ) : ?>

		<span class="sku_wrapper"><?php esc_html_e( 'SKU:', 'Garden' ); ?> <span class="sku" itemprop="sku"><?php echo ( $sku = $product->get_sku() ) ? wp_kses_post($sku) : esc_html__( 'N/A', 'Garden' ); ?></span>.</span>

	<?php endif; ?>

	<?php echo wp_kses_post($product->get_categories( ', ', '<span class="posted_in">' . _n( 'Category:', 'Categories:', $cat_count, 'Garden' ) . ' ', '.</span>' )); ?>

	<?php echo wp_kses_post($product->get_tags( ', ', '<span class="tagged_as">' . _n( 'Tag:', 'Tags:', $tag_count, 'Garden' ) . ' ', '.</span>' )); ?>
	
	
	
	<?php do_action( 'woocommerce_product_meta_end' ); ?>

</div>

<?php if ( garden_pix_get_option('garden_pix_product_share','1') ) : ?>
		<div class="pix-product-share">
			<?php echo do_shortcode('[share]'); ?>
		</div>
	<?php endif; ?>