<?php


/***********************************

	Plugin Name:  PixthemeCustom
	Plugin URI:   http://templines.com/
	Description:  Additional functionality for PixTheme
	Version:      1.0
	Author:       PixTheme
	Author URI:   http://templines.com
	License:      GPLv2 or later	
	Text Domain:  PixThemeCustom
	Domain Path:  /languages/
	
***********************************/
if ( ! defined( 'ABSPATH' ) ) {
	exit; // disable direct access
}


/************* STATICBLOCK ***************/


	if(!function_exists('pixtheme_init_staticblocks')) {
	function pixtheme_init_staticblocks(){
			$labels = array(
				'name'               => _x( 'Static Blocks', 'post type general name', 'PixTheme' ),
				'singular_name'      => _x( 'Static Block', 'post type singular name', 'PixTheme' ),
				'menu_name'          => _x( 'Static Blocks', 'admin menu', 'PixTheme' ),
				'name_admin_bar'     => _x( 'Static Block', 'add new on admin bar', 'PixTheme' ),
				'add_new'            => _x( 'Add New', 'book', 'PixTheme' ),
				'add_new_item'       => __( 'Add New Block', 'PixTheme' ),
				'new_item'           => __( 'New Block', 'PixTheme' ),
				'edit_item'          => __( 'Edit Block', 'PixTheme' ),
				'view_item'          => __( 'View Block', 'PixTheme' ),
				'all_items'          => __( 'All Blocks', 'PixTheme' ),
				'search_items'       => __( 'Search Block', 'PixTheme' ),
				'parent_item_colon'  => __( 'Parent Block:', 'PixTheme' ),
				'not_found'          => __( 'No blocks found.', 'PixTheme' ),
				'not_found_in_trash' => __( 'No blocks found in Trash.', 'PixTheme' )
			);
	
			$args = array(
				'labels'             => $labels,
				'public'             => true,
				'publicly_queryable' => true,
				'show_ui'            => true,
				'show_in_menu'       => true,
				'query_var'          => true,
				'rewrite'            => array( 'slug' => 'staticblock' ),
				'capability_type'    => 'post',
				'has_archive'        => 'staticblocks',
				'hierarchical'       => false,
				'menu_position'      => 8,
				'supports'           => array( 'title', 'editor',  'thumbnail', 'page-attributes', 'comments' ),
				'menu_icon'			 => get_template_directory_uri() . "/library/functions/img/pix-static.png"
			);
		
	
	        register_post_type( 'staticblocks', $args );
		}
	
	}
	if(!function_exists('pix_show_productpage_static_block')) {
			function pix_show_productpage_static_block() {
			    $product = get_post(get_the_ID());
				// Do not show this on variable products
				if ( $product->product_type <> 'variable' ) {
					$args = array(
						'post_type'        => 'staticblocks',
						'post_status'      => 'publish',
					);
					$staticBlocksData = get_posts( $args );
					foreach($staticBlocksData as $_block){
						$staticBlocks[$_block->ID] = $_block->post_title;
					}
				
				
					
		
					
					$staticblock = get_post_meta( $product->ID, '_static_bottom', true );
		
					echo '<div class="show_if_simple show_if_variable">';
					pixtheme_wp_select_multiple( array( 
						'id' => '_static_bottom', 
						'label' => __( 'Static Block Description', 'PixTheme' ), 
						'options' => $staticBlocks, 
						'name' => '_static_bottom[]',
						'desc_tip' => true, 
						'description' => __( 'Select the block to display at the bottom of the product page' , 'PixTheme'),
						'value' => explode(",",$staticblock)
					) );
			
					echo '</div>';
				}
			}
		}
		
		
		if(!function_exists('pixtheme_add_bottom_block_product')) {
			function pixtheme_add_bottom_block_product() {
				$output = "";
				$product = get_post(get_the_ID());
				$staticblockIDs = get_post_meta( $product->ID, '_static_bottom', true );
				$staticblockIDsExploded = explode(',',$staticblockIDs);
				foreach($staticblockIDsExploded as $_staticblockID){
					if (!is_numeric($_staticblockID)) continue;
					$staticblock = get_post($_staticblockID);
					$output .= '<div class="stblock_content">' . apply_filters( 'the_content',$staticblock->post_content) . '</div>';
				}
				
				echo $output;
			}
		}
		
		
		
		if(!function_exists('pixtheme_woocommerce_product_quick_edit_save')) {
			function pixtheme_woocommerce_product_quick_edit_save($product_id){
				
				if ( isset( $_REQUEST['_static_bottom'] ) ){
					if (!get_post_meta( $product_id, '_static_bottom', true )){
						add_post_meta($product_id, '_static_bottom', wc_clean( implode(",",$_REQUEST['_static_bottom'] )));
					}else{
						update_post_meta( $product_id, '_static_bottom', wc_clean( implode(",",$_REQUEST['_static_bottom'] )) );	
					}
					
				}else{
					if (get_post_meta( $product_id, '_static_bottom', true )){
						update_post_meta( $product_id, '_static_bottom', wc_clean( "," ) );	
					}
				}
			}
		}
				
		
		
		
		if(!function_exists('pixtheme_staticblocks_get')) {
		    function pixtheme_staticblocks_get () {
		        $return_array = array();
		        $args = array( 'post_type' => 'staticblocks', 'posts_per_page' => 30);     
				$myposts = get_posts( $args );
		        $i=0;
		        foreach ( $myposts as $post ) {
		            $i++;
		            $return_array[$i]['label'] = get_the_title($post->ID);
		            $return_array[$i]['value'] = $post->ID;
		        } 
		        wp_reset_postdata();
		        return $return_array;
		    }
		}
		
		
		if(!function_exists('pixtheme_staticblocks_show')) {
		    function pixtheme_staticblocks_show ($id = false) {
		        echo pixtheme_staticblocks_single($id);
		    }
		}
		
		
		if(!function_exists('pixtheme_staticblocks_single')) {
		    function pixtheme_staticblocks_single($id = false) {
		    	if(!$id) return;
		    	
		    	$output = false;
		    	
		    	$output = wp_cache_get( $id, 'pixtheme_staticblocks_single' );
		    	
			    if ( !$output ) {
			   
			        $args = array( 'include' => $id,'post_type' => 'staticblocks', 'posts_per_page' => 1);
			        $output = '';
			        $myposts = get_posts( $args );
			        foreach ( $myposts as $post ) {
			        	setup_postdata($post);
						
			        	$output = do_shortcode(get_the_content($post->ID));
			        	
						$shortcodes_custom_css = get_post_meta( $post->ID, '_wpb_shortcodes_custom_css', true );
						if ( ! empty( $shortcodes_custom_css ) ) {
							$output .= '<style type="text/css" data-type="vc_shortcodes-custom-css">';
							$output .= $shortcodes_custom_css;
							$output .= '</style>';
						}
			        } 
			        wp_reset_postdata();
			        
			        wp_cache_add( $id, $output, 'pixtheme_staticblocks_single' );
			    }
			    
		        return $output;
		   }
		}
		
		
		
/************* PORTFOLIO ***************/

add_action('init', 'pixtheme_portfolio_register');

function pixtheme_portfolio_register() {	

	register_post_type( 'portfolio' , 
						array(
							'label' => 'Portfolio',
							'singular_label' => 'Portfolio',
							'exclude_from_search' => false,
							'publicly_queryable' => true,
							'menu_position' => null,
							'show_ui' => true, 
							'public'  =>   true,
							'show_in_menu'  =>   true,
							'menu_icon'     =>   get_template_directory_uri() . '/library/functions/img/pix-portfolio.png',
							'query_var' => true,
							'capability_type' => 'page',
							'hierarchical' => false,
							'edit_item' => __( 'Edit Work', 'PixTheme'),
							'supports' => array('title', 'editor', 'thumbnail', 'excerpt')
						)
					);

	register_taxonomy( 'portfolio_category', 
						'portfolio', 
						array( 'hierarchical' => true, 
								'label' => __('Categories', 'PixTheme'),
								'singular_label' => __('Category', 'PixTheme'), 
								'public' => true,
  								'show_tagcloud' => false,
								'query_var' => true,
			 					'rewrite' => array('slug' => 'portfolio_category' , 'with_front' => false)
						)
					);  
	
	add_filter('manage_edit-portfolio_columns', 'pixtheme_portfolio_edit_columns');
	add_action('manage_posts_custom_column',  'pixtheme_portfolio_custom_columns');
	
	function pixtheme_portfolio_edit_columns($columns){
		$columns = array(
			'cb' => '<input type="checkbox" />',
			'portfolio_image' => 'Image Preview',
			'title' => 'Title',
			'portfolio_category' => 'Category',
			'portfolio_description' => 'Description',
			
		);
	
		return $columns;
	}
	
	function pixtheme_portfolio_custom_columns($column){
		global $post;
		switch ($column)
		{
			case "portfolio_category":  
				echo get_the_term_list($post->ID, 'portfolio_category', '', ', ','');  
				break;  

			case 'portfolio_description':
				the_excerpt();  
				break;  

			case 'portfolio_image':
				the_post_thumbnail( 'blog-thumb' );
				break;
		}
	}
}


function pixtheme_post_type_link_filter_function( $post_link, $id = 0, $leavename = FALSE ) {
    if ( strpos('%portfolio_category%', $post_link)  < 0 ) {
      return $post_link;
    }
    $post = get_post($id);
    if ( !is_object($post) || $post->post_type != 'portfolio' ) {
      return $post_link;
    }
    $terms = wp_get_object_terms($post->ID, 'portfolio_category');
    if ( !$terms ) {
      return str_replace('portfolio/category/%portfolio_category%/', '', $post_link);
    }
    return str_replace('%portfolio_category%', $terms[0]->slug, $post_link);
}
  
add_filter('post_type_link', 'pixtheme_post_type_link_filter_function', 1, 3);
  

add_action( 'admin_menu', 'pixtheme_register_portfolio_menu' );

function pixtheme_register_portfolio_menu() {
	add_submenu_page(
		'edit.php?post_type=portfolio',
		'Order portfolio',
		'Sort items',
		'edit_pages', 'portfolio-order',
		'pixtheme_portfolio_order_page'
	);
}


function pixtheme_portfolio_order_page() 
{
	?></pre>
	<div class="wrap">
        <h2>Sort Items</h2>
        Simply drag the items up or down and they will be saved in that order.
        
        <?php $slides = new WP_Query( array( 'post_type' => 'portfolio', 'posts_per_page' => -1, 'order' => 'ASC', 'orderby' => 'menu_order' ) ); ?>
        <table id="sortable-table-portfolio" class="wp-list-table widefat fixed posts">
            <thead>
                <tr>
                    <th class="column-order">Order</th>
                    <th class="column-title">Title</th>
                    <th class="column-thumbnail">Thumbnail</th>
         
                </tr>
            </thead>
            <tbody data-post-type="portfolio"><!--?php while( $products--->
				<?php if( $slides->have_posts() )  : ?>
                    <?php while ($slides->have_posts()): $slides->the_post(); ?>
                        <tr id="post-<?php esc_attr(the_ID()); ?>">
                            <td class="column-order"><img title="" src="<?php echo esc_url(get_stylesheet_directory_uri()) . '/images/move-icon-vertical.png'; ?>" alt="Move Icon" height="32" /></td>
                            <td class="column-title"><strong><?php the_title(); ?></strong></td>
                    		<td class="column-thumbnail"><?php the_post_thumbnail( 'blog-thumb' ); ?></td>
                         </tr>
                    <?php endwhile; ?>
                <?php else : ?>        
                    No portfolio items found, make sure you create one.
                <?php endif; ?>
                <?php wp_reset_postdata(); ?>	
            </tbody>
            <tfoot>
                <tr>
                    <th class="column-order">Order</th>
                    <th class="column-title">Title</th>
                    <th class="column-thumbnail">Thumbnail</th>
                </tr>
            </tfoot>
        </table>
 	</div>
	<pre>
	<!-- .wrap -->	
	<?php 
}

add_action( 'wp_ajax_pixtheme_portfolio_update_post_order', 'pixtheme_portfolio_update_post_order' );

function pixtheme_portfolio_update_post_order() {
	global $wpdb;

	$post_type     = $_POST['postType'];
	$order        = $_POST['order'];

	/**
	*    Expect: $sorted = array(
	*                menu_order => post-XX
	*            );
	*
	*/
	
	foreach( $order as $menu_order => $post_id )
	{
		$post_id         = intval( str_ireplace( 'post-', '', $post_id ) );
		$menu_order     = intval($menu_order);
		wp_update_post( array( 'ID' => $post_id, 'menu_order' => $menu_order ) );
	}

	die( '1' );
}




/************* EVENTS ******************/

function pix_event_post_type() {
	
	$labels = array(
		'name'                  =>   __( 'Events', 'PixTheme' ),
		'singular_name'         =>   __( 'Event', 'PixTheme' ),
		'add_new_item'          =>   __( 'Add New Event', 'PixTheme' ),
		'all_items'             =>   __( 'All Events', 'PixTheme' ),
		'edit_item'             =>   __( 'Edit Event', 'PixTheme' ),
		'new_item'              =>   __( 'New Event', 'PixTheme' ),
		'view_item'             =>   __( 'View Event', 'PixTheme' ),
		'not_found'             =>   __( 'No Events Found', 'PixTheme' ),
		'not_found_in_trash'    =>   __( 'No Events Found in Trash', 'PixTheme' )
	);
	 
	$supports = array(
		'title',
		'editor',
		'thumbnail',
		'excerpt'
	);
	 
	$args = array(
		'label'         =>   __( 'Events', 'PixTheme' ),
		'labels'        =>   $labels,
		'description'   =>   __( 'A list of upcoming events', 'PixTheme' ),
		'public'        =>   true,
		'show_in_menu'  =>   true,
		'menu_icon'     =>   get_template_directory_uri() . '/library/functions/img/event.png',
		'has_archive'   =>   true,
		'rewrite'       =>   true,
		'supports'      =>   $supports
	);
	 
	register_post_type( 'event', $args );
	
	register_taxonomy( 'event_category', 
						'event', 
						array( 'hierarchical' => true, 
								'label' => __('Categories', 'PixTheme'),
								'singular_label' => __('Category', 'PixTheme'), 
								'public' => true,
  								'show_tagcloud' => false,
								'query_var' => 'true',
			 					'rewrite' => array('slug' => 'event_category' , 'with_front' => false)
						)
					);
					
	add_filter( 'manage_edit-event_columns', 'pix_custom_columns_head', 10 );
	add_action( 'manage_posts_custom_column', 'pix_custom_columns_content', 10, 2 );
	
	function pix_custom_columns_head( $defaults ) {
		unset( $defaults['date'] );
	 	unset( $defaults['title'] );
		
	 	$defaults['event_image'] = __( 'Image Preview', 'uep' );
		$defaults['title'] = __( 'Title', 'uep' );
	 	$defaults['event_category'] = __( 'Category', 'uep' );
		$defaults['event_start_date'] = __( 'Start Date', 'uep' );
		$defaults['event_end_date'] = __( 'End Date', 'uep' );
		$defaults['event_venue'] = __( 'Venue', 'uep' );
	 
		return $defaults;
	}
	
	
	function pix_custom_columns_content( $column_name, $post_id ) {
				
	 	if ( 'event_image' == $column_name ) {
			the_post_thumbnail( 'blog-thumb' );
		}
		
		if ( 'event_category' == $column_name ) {
			echo get_the_term_list($post_id, 'event_category', '', ', ',''); 
		}		
		
		if ( 'event_start_date' == $column_name ) {
			$start_date = get_post_meta( $post_id, 'event-start-date', true );
			echo date( 'F d, Y', $start_date );
		}
	 
		if ( 'event_end_date' == $column_name ) {
			$end_date = get_post_meta( $post_id, 'event-end-date', true );
			echo date( 'F d, Y', $end_date );
		}
	 
		if ( 'event_venue' == $column_name ) {
			$venue = get_post_meta( $post_id, 'event-venue', true );
			echo wp_kses_post($venue);
		}
	}
	

}



add_action('init', 'pixtheme_portfolio_register');
//add_action( 'init', 'pix_event_post_type' );
add_action( 'init', 'pixtheme_init_staticblocks' );
add_action( 'woocommerce_product_options_advanced', 'pix_show_productpage_static_block', 55 );
add_action('save_post','pixtheme_woocommerce_product_quick_edit_save');
add_action('woocommerce_after_single_product_summary','pixtheme_add_bottom_block_product',15);


/************** Multiselect Field***************/
function pixtheme_wp_select_multiple( $field ) {
    global $thepostid, $post, $woocommerce;

    $thepostid              = empty( $thepostid ) ? $post->ID : $thepostid;
    $field['class']         = isset( $field['class'] ) ? $field['class'] : 'select short';
    $field['wrapper_class'] = isset( $field['wrapper_class'] ) ? $field['wrapper_class'] : '';
    $field['name']          = isset( $field['name'] ) ? $field['name'] : $field['id'];
    $field['value']         = isset( $field['value'] ) ? $field['value'] : ( get_post_meta( $thepostid, $field['id'], true ) ? get_post_meta( $thepostid, $field['id'], true ) : array() );

    echo '<p class="form-field ' . esc_attr( $field['id'] ) . '_field ' . esc_attr( $field['wrapper_class'] ) . '"><label for="' . esc_attr( $field['id'] ) . '">' . wp_kses_post( $field['label'] ) . '</label><select id="' . esc_attr( $field['id'] ) . '" name="' . esc_attr( $field['name'] ) . '" class="' . esc_attr( $field['class'] ) . '" multiple="multiple">';

    foreach ( $field['options'] as $key => $value ) {

        echo '<option value="' . esc_attr( $key ) . '" ' . ( in_array( $key, $field['value'] ) ? 'selected="selected"' : '' ) . '>' . esc_html( $value ) . '</option>';

    }

    echo '</select> ';

    if ( ! empty( $field['description'] ) ) {

        if ( isset( $field['desc_tip'] ) && false !== $field['desc_tip'] ) {
            echo '<img class="help_tip" data-tip="' . esc_attr( $field['description'] ) . '" src="' . esc_url( WC()->plugin_url() ) . '/assets/images/help.png" height="16" width="16" />';
        } else {
            echo '<span class="description">' . wp_kses_post( $field['description'] ) . '</span>';
        }

    }
    echo '</p>';
}
/********************************************/

function garden_pix_share_buttons($atts, $content=NULL){

	extract(shortcode_atts(array(
        'post_type'=>'',
    ), $atts));

	global $post;
	if(!isset($post->ID)) return;
	$permalink = get_permalink($post->ID);
	$image =  wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'preview-thumb' );

	$post_title = rawurlencode(get_the_title($post->ID));

	if( $post_type == '' ){
    	$out='
			<ul class="cont-share">
				<li><span class="bold">'. esc_html__('Share:' , 'Garden').'</span></li>
				<li><span class="share-icon"><a href="http://www.facebook.com/sharer.php?u='.$permalink.'&amp;images='.$image[0].'" title="'.esc_html__('Facebook', 'Garden').'" target="_blank"><span class="ef social_facebook_square "></span></a></span></li>
				<li><span class="share-icon"><a href="https://twitter.com/share?url='.$permalink.'&text='.$post_title.'" title="'.esc_html__('Twitter', 'Garden').'" target="_blank"><span class="ef social_twitter_square "></span></a></span></li>
				<li><span class="share-icon"><a href="http://pinterest.com/pin/create/button/?url='.$permalink.'&amp;media='.$image[0].'&amp;description='.$post_title.'" title="" target="_blank"><span class="ef social_pinterest_square "></span></a></span></li>
				<li><span class="share-icon"><a href="http://plus.google.com/share?url='.$permalink.'&title='.$post_title.'" title="'.esc_html__('Google +', 'Garden').'" target="_blank"><span class="ef social_googleplus_square "></span></a></span></li>
			</ul>
			';
	} else {
		$out='
			<div class="type-info pull-left">
				<h5>'. esc_html__('Share:' , 'Garden').'</h5>
			</div>
			<ul class="copyright-links pull-right list-inline">
				<li><a href="http://www.facebook.com/sharer.php?u='.$permalink.'&amp;images='.$image[0].'" title="'.esc_html__('Facebook', 'Garden').'" target="_blank"><i class="fa fa-facebook fa-lg"></i></a></li>
                  <li><a href="https://twitter.com/share?url='.$permalink.'&text='.$post_title.'" title="'.esc_html__('Twitter', 'Garden').'" target="_blank"><i class="fa fa-twitter fa-lg"></i></a></li>
                  <li><a href="http://plus.google.com/share?url='.$permalink.'&title='.$post_title.'" title="'.esc_html__('Google +', 'Garden').'" target="_blank"><i class="fa fa-google-plus fa-lg"></i></a></li>
                  <li><a href="http://pinterest.com/pin/create/button/?url='.$permalink.'&amp;media='.$image[0].'&amp;description='.$post_title.'" title="" target="_blank"><i class="fa fa-pinterest fa-lg"></i></a></li>
			</ul>
			';
	}

    return $out;
}

add_shortcode('share', 'garden_pix_share_buttons');

add_action('admin_head','html_quicktags');
function html_quicktags() {

	$output = "<script type='text/javascript'>\n
	/* <![CDATA[ */ \n";
	wp_print_scripts( 'quicktags' );




	$buttons[] = array(
		'name' => 'widgettitle',
		'options' => array(
			'display_name' => 'widgettitle',
			'open_tag' => '\n[widgettitle]',
			'close_tag' => '[/widgettitle]\n',
			'key' => ''
	));



	/*$buttons[] = array(
		'name' => 'linetitle',
		'options' => array(
			'display_name' => 'linetitle',
			'open_tag' => '\n[linetitle]',
			'close_tag' => '[/linetitle]\n',
			'key' => ''
	));*/



	$buttons[] = array(
		'name' => 'thin_title',
		'options' => array(
			'display_name' => 'thin_title',
			'open_tag' => '\n[thin_title]',
			'close_tag' => '[/thin_title]\n',
			'key' => ''
	));

/*  $buttons[] = array(
		'name' => 'highlight_text',
		'options' => array(
			'display_name' => 'highlight_text',
			'open_tag' => '\n[highlight_text]',
			'close_tag' => '[/highlight_text]\n',
			'key' => ''
	));*/


/*
	$buttons[] = array(
		'name' => 'btn_icon',
		'options' => array(
			'display_name' => 'btn_icon',
			'open_tag' => '\n[btn_icon  link="http://google.com"  type="right"]',
			'close_tag' => '[/btn_icon]\n',
			'key' => ''
	));*/


	/*	$buttons[] = array(
		'name' => 'btn_download',
		'options' => array(
			'display_name' => 'btn_download',
			'open_tag' => '\n[btn_download  link="http://google.com" ]',
			'close_tag' => '[/btn_download]\n',
			'key' => ''
	));*/



	$buttons[] = array(
		'name' => 'icon_box',
		'options' => array(
			'display_name' => 'icon_box',
			'open_tag' => '\n[icon_box  icon="fa-flag"  type="fa-2x"]',
			'close_tag' => '[/icon_box]\n',
			'key' => ''
	));



	/*
	$buttons[] = array(
		'name' => 'marked_list1',
		'options' => array(
			'display_name' => 'marked_list1',
			'open_tag' => '\n[marked_list1]',
			'close_tag' => '[/marked_list1]\n',
			'key' => ''
	));
	*/

	/*$buttons[] = array(
		'name' => 'marked_list2',
		'options' => array(
			'display_name' => 'marked_list2',
			'open_tag' => '\n[marked_list2]',
			'close_tag' => '[/marked_list2]\n',
			'key' => ''
	));*/


	for ($i=0; $i <= (count($buttons)-1); $i++) {
		$output .= "edButtons[edButtons.length] = new edButton('ed_{$buttons[$i]['name']}'
			,'{$buttons[$i]['options']['display_name']}'
			,'{$buttons[$i]['options']['open_tag']}'
			,'{$buttons[$i]['options']['close_tag']}'
			,'{$buttons[$i]['options']['key']}'
		); \n";
	}

	$output .= "\n /* ]]> */ \n
	</script>";
	echo $output;
}

function garden_pix_addbuttons() {
	if ( ! current_user_can('edit_posts') && ! current_user_can('edit_pages') )
		return;

	if ( get_user_option('rich_editing') == 'true') {
		add_filter('mce_buttons_3', 'register_garden_pix_custom_button');
	}
}
function register_garden_pix_custom_button($buttons) {
	array_push(
		$buttons,
		"title_block",
		"title_image",
		"thin_title",
		"linetitle",
		"widgettitle",
		"highlight_text",

		"btn_icon",
		"hexagon",
		"state"

		);
	return $buttons;
}
function add_garden_pix_custom_tinymce_plugin($plugin_array) {
	return $plugin_array;
}
add_action('init', 'garden_pix_addbuttons');


/******************* widgettitle *******************/

function alc_widgettitle( $atts, $content = null ) {
     extract(shortcode_atts(array(
		"title"=>''
	), $atts));
	$out = '<h3 class="widgettitle">'.$content.'</h3>';
   return $out;
}
add_shortcode('widgettitle', 'alc_widgettitle');

/******************* linetitle *******************/

function alc_linetitle( $atts, $content = null ) {
     extract(shortcode_atts(array(
		"title"=>''
	), $atts));
	$out = '<div class="linetitle">'.$content.'</div>';
   return $out;
}
add_shortcode('linetitle', 'alc_linetitle');

/******************* thin_title *******************/

function alc_thin_title( $atts, $content = null ) {
     extract(shortcode_atts(array(
		"title"=>''
	), $atts));
	$out = '<div class="light-font">'.$content.'</div>';
   return $out;
}
add_shortcode('thin_title', 'alc_thin_title');


/******************* highlight_text *******************/

function alc_highlight_text( $atts, $content = null ) {
     extract(shortcode_atts(array(
		"title"=>''
	), $atts));
	$out = '<span class="highlight_text">'.$content.'</span>';
   return $out;
}
add_shortcode('highlight_text', 'alc_highlight_text');


/******************* btn_icon *******************/

function alc_btn_icon( $atts, $content = null ) {
     extract(shortcode_atts(array(
		"link"=>'',
		"type"=>''
	), $atts));
	$out = '<div class="btn-icon-wrap"><a href="'.$link.'" class="btn  btn-primary btn-icon-'.$type.' ">'.$content.'
          <div class="btn-icon"><i class="fa fa-long-arrow-'.$type.'"></i></div>
          </a></div>';
   return $out;
}
add_shortcode('btn_icon', 'alc_btn_icon');


/******************* btn_download *******************/

function alc_btn_download( $atts, $content = null ) {
     extract(shortcode_atts(array(
		"link"=>''
	), $atts));
	$out = '

	<a class="btn-download" href="'.$link.'"><i class="fa fa-file-pdf-o"></i>'.$content.'</a>

';
   return $out;
}
add_shortcode('btn_download', 'alc_btn_download');





/******************* icon_box *******************/

function alc_icon_box( $atts, $content = null ) {
     extract(shortcode_atts(array(
		"icon"=>'',
		"type"=>''
	), $atts));
	$out = '<span class="icon_box_wrap"><i class="fa '.$icon.'  '.$type.'"></i></span>'.$content.'';
   return $out;
}
add_shortcode('icon_box', 'alc_icon_box');


/******************* marked_list1 *******************/

function alc_marked_list1( $atts, $content = null ) {
     extract(shortcode_atts(array(
		"icon"=>'',
		"type"=>''
	), $atts));
	$out = '<div class="marked_list1">'.$content.'</div>';
   return $out;
}
add_shortcode('marked_list1', 'alc_marked_list1');


/******************* marked_list2 *******************/

function alc_marked_list2( $atts, $content = null ) {
     extract(shortcode_atts(array(
		"icon"=>'',
		"type"=>''
	), $atts));
	$out = '<div class="marked_list2">'.$content.'</div>';
   return $out;
}
add_shortcode('marked_list2', 'alc_marked_list2');

?>