<?php

add_action( 'add_meta_boxes', 'posts_init' );
function posts_init(){
	add_meta_box("sidebar_options", __("Sidebar & Footer Options", 'Garden'), "garden_pix_sidebar_options", null, "side", "low");
}

/** START SIDEBAR OPTIONS */

function garden_pix_sidebar_options(){	
	global $post;
	$post_id = $post;
	if (is_object($post_id)) {
		$post_id = $post_id->ID;
	}
	
	$selected_type_sidebar = (get_post_meta($post_id, 'garden_pix_page_layout', true) == "") ? 2 : get_post_meta($post_id, 'garden_pix_page_layout', true);
	$selected_sidebar = get_post_meta($post_id, 'garden_pix_selected_sidebar', true);
	if(!is_array($selected_sidebar)){
		$tmp = $selected_sidebar; 
		$selected_sidebar = array(); 
		$selected_sidebar[0] = $tmp;
	}
	
	$selected_footer_block = (get_post_meta($post_id, 'garden_pix_footer_staticblock', true) == "") ? 'global' : get_post_meta($post_id, 'garden_pix_footer_staticblock', true);
	$args = array(
		'post_type'        => 'staticblocks',
		'post_status'      => 'publish',
	);
	$staticBlocks = array();
	$staticBlocks['global'] = __('Use global settings','Garden');
	$staticBlocksData = get_posts( $args );
	foreach($staticBlocksData as $_block){
		$staticBlocks[$_block->ID] =  $_block->post_title;
	}
	
	?>
	
	<p><strong><?php echo __('Sidebar type', 'Garden')?></strong></p>
	
	<select class="rwmb-select" name="garden_pix_page_layout" id="garden_pix_page_layout" size="0">
		<option value="1" <?php if ($selected_type_sidebar == 1):?>selected="selected"<?php endif?>><?php echo __('Full width', 'Garden')?></option>
		<option value="2" <?php if ($selected_type_sidebar == 2):?>selected="selected"<?php endif?>><?php echo __('Right Sidebar', 'Garden')?></option>
		<option value="3" <?php if ($selected_type_sidebar == 3):?>selected="selected"<?php endif?>><?php echo __('Left Sidebar', 'Garden')?></option>
	</select>
	<?php ?>
	
	<p><strong><?php echo __('Sidebar content', 'Garden')?></strong></p>
	<ul>
	<?php 
	global $wp_registered_sidebars;
	//var_dump($wp_registered_sidebars);		
		for($i=0;$i<1;$i++){ ?>
			<li>
			<select class="rwmb-select" name="sidebar_generator[<?php echo esc_attr($i)?>]">
				<option value="global-sidebar-1"<?php if($selected_sidebar[$i] == ''){ echo " selected";} ?>><?php echo __('WP Default Sidebar', 'Garden')?></option>
			<?php
			$sidebars = $wp_registered_sidebars;// sidebar_generator::get_sidebars();
			if(is_array($sidebars) && !empty($sidebars)){
				foreach($sidebars as $sidebar){
					if($selected_sidebar[$i] == $sidebar['id']){
						echo "<option value='".esc_attr($sidebar['id'])."' selected>{$sidebar['name']}</option>\n";
					}else{
						echo "<option value='".esc_attr($sidebar['id'])."'>{$sidebar['name']}</option>\n";
					}
				}
			}
			?>
			</select>
			</li>
		<?php } ?>
	</ul>
    
    <p><strong><?php echo __('Footer Static Block', 'Garden')?></strong></p>
	<ul>

			<li>
			<select name="garden_pix_footer_staticblock">				
			<?php foreach($staticBlocks as $id => $_staticBlock){ 
					if($id == $selected_footer_block){
						echo "<option value='".esc_attr($id)."' selected>".esc_attr($_staticBlock)."</option>\n";
					}else{
						echo "<option value='".esc_attr($id)."'>".esc_attr($_staticBlock)."</option>\n";
					}
				}
			?>
			</select>
			</li>
	</ul>
    
<?php }

/** END SIDEBAR OPTIONS */


function save_postdata( $post_id ) {
	
	if ( wp_is_post_revision( $post_id ) )
		return;
		
		
	global $post, $new_meta_boxes;

	
	if(isset($new_meta_boxes))
	foreach($new_meta_boxes as $meta_box) {
		
		if ( $meta_box['type'] != 'title)' ) {
		
			if ( 'page' == $_POST['post_type'] ) {
				if ( !current_user_can( 'edit_page', $post_id ))
					return $post_id;
			} else {
				if ( !current_user_can( 'edit_post', $post_id ))
					return $post_id;
			}
			
			if (isset($_POST[$meta_box['name']]) && is_array($_POST[$meta_box['name']]) ) {
				$cats = '';
				foreach($_POST[$meta_box['name']] as $cat){
					$cats .= $cat . ",";
				}
				$data = substr($cats, 0, -1);
			}
			
			else { $data = ''; if(isset($_POST[$meta_box['name']])) $data = $_POST[$meta_box['name']]; }			
			
			if(get_post_meta($post_id, $meta_box['name']) == "")
				add_post_meta($post_id, $meta_box['name'], $data, true);
			elseif($data != get_post_meta($post_id, $meta_box['name'], true))
				update_post_meta($post_id, $meta_box['name'], $data);
			elseif($data == "")
				delete_post_meta($post_id, $meta_box['name'], get_post_meta($post_id, $meta_box['name'], true));
				
		}
	}
	
	garden_pix_save_sidebar_data( $post_id );
	
}

function garden_pix_save_sidebar_data( $post_id ){

	global $post;
	
	if (isset($_POST['garden_pix_page_layout'])){
		if(get_post_meta($post_id, 'garden_pix_page_layout') == "")
			add_post_meta($post_id, 'garden_pix_page_layout', $_POST['garden_pix_page_layout'], true);
		else
			update_post_meta($post_id, 'garden_pix_page_layout', $_POST['garden_pix_page_layout']);
	}
	
	if (isset($_POST['sidebar_generator'][0])){
		if(get_post_meta($post_id, 'garden_pix_page_layout') == "")
			add_post_meta($post_id, 'garden_pix_selected_sidebar', $_POST['sidebar_generator'][0], true);
		else
			update_post_meta($post_id, 'garden_pix_selected_sidebar', $_POST['sidebar_generator'][0]);
	}
	
	if (isset($_POST['garden_pix_footer_staticblock'])){
		if(get_post_meta($post_id, 'garden_pix_footer_staticblock') == "")
			add_post_meta($post_id, 'garden_pix_footer_staticblock', $_POST['garden_pix_footer_staticblock'], true);
		else
			update_post_meta($post_id, 'garden_pix_footer_staticblock', $_POST['garden_pix_footer_staticblock']);
	}

}

add_action('save_post', 'save_postdata');



/////////// Category Thumbnail For Taxonomy ////////////

add_action('admin_head', 'garden_pix_admin_head_thumb');
add_action('edit_term', 'garden_pix_save_tax_thumb');
add_action('create_term', 'garden_pix_save_tax_thumb');
function garden_pix_admin_head_thumb() {
    $taxonomies = get_taxonomies();
    $taxonomies = array('category', 'portfolio_category'); // укажите определенные таксономии, в которые хотите добавить изображение
    if (is_array($taxonomies)) {
        foreach ($taxonomies as $garden_pix_taxonomy) {
            add_action($garden_pix_taxonomy . '_add_form_fields', 'garden_pix_tax_field');
            add_action($garden_pix_taxonomy . '_edit_form_fields', 'garden_pix_tax_field');
        }
    }
}

add_filter('manage_edit-portfolio_category_columns', 'garden_pix_portfolio_category_columns');
add_filter('manage_portfolio_category_custom_column', 'garden_pix_portfolio_category_custom_column', 10, 3);

function garden_pix_portfolio_category_columns($columns){
	unset(
		$columns['cb']
	);
	$new_columns = array(		
		'cb' => '<input type="checkbox" />',
		'thumbnail' =>  __('Thumbnail', 'Garden'),
	);
    return array_merge($new_columns, $columns);
}

function garden_pix_portfolio_category_custom_column($c, $column_name, $term_id){		
	$t_id = $term_id;
	$garden_pix_tax_thumb_url = get_option("garden_pix_tax_thumb".$t_id);
	switch ($column_name)
	{
		case "thumbnail":  ;
			if(!empty($garden_pix_tax_thumb_url))
            	echo '<img src="'.esc_url($garden_pix_tax_thumb_url).'" style="max-width:100px;" >';           
			break;  
		
		default:
			break;
	}
}

add_filter('manage_edit-category_columns', 'garden_pix_category_columns');
add_filter('manage_category_custom_column', 'garden_pix_category_custom_column', 10, 3);

function garden_pix_category_columns($columns){
	unset(
		$columns['cb']
	);
	$new_columns = array(		
		'cb' => '<input type="checkbox" />',
		'thumbnail' =>  __('Thumbnail', 'Garden'),
	);
    return array_merge($new_columns, $columns);
}

function garden_pix_category_custom_column($c, $column_name, $term_id){		
	$t_id = $term_id;
	$garden_pix_tax_thumb_url = get_option("garden_pix_tax_thumb".$t_id);
	switch ($column_name)
	{
		case "thumbnail":  ;
			if(!empty($garden_pix_tax_thumb_url))
            	echo '<img src="'.esc_url($garden_pix_tax_thumb_url).'" style="max-width:100px;" >';           
			break;  
		
		default:
			break;
	}	
}

// добавляем поле картинки в форме
function garden_pix_tax_field($taxonomy) {
    wp_enqueue_style('thickbox');
    wp_enqueue_script('thickbox');
    if(!is_object($taxonomy)) {
        echo '<div class="form-field">
                <label for="garden_pix_tax_thumb">'.__('Thumbnail', 'Garden').'</label>
                <input type="text" name="garden_pix_tax_thumb" id="garden_pix_tax_thumb" value="" />
            </div>';
    }
    else{
        $garden_pix_tax_thumb_url = get_option('garden_pix_tax_thumb' . $taxonomy->term_id);
        echo '<tr class="form-field">
		<th scope="row" valign="top"><label for="garden_pix_tax_thumb">'.__('Thumbnail', 'Garden').'</label></th>
		<td><input type="text" name="garden_pix_tax_thumb" id="garden_pix_tax_thumb" value="' . $garden_pix_tax_thumb_url . '" /><br />';
        if(!empty($garden_pix_tax_thumb_url))
            echo '<img src="'.$garden_pix_tax_thumb_url.'" style="max-width:200px;border: 1px solid #ccc;padding: 5px;box-shadow: 5px 5px 10px #ccc;margin-top: 10px;" >';
        echo '</td></tr>';        
    }
    echo '<script type="text/javascript">
	    jQuery(document).ready(function() {
                jQuery("#garden_pix_tax_thumb").click(function() {
                    tb_show("", "media-upload.php?type=image&amp;TB_iframe=true&amp;width=800&amp;height=600");
                    return false;
                });
                window.send_to_editor = function(html) {
                    jQuery("#garden_pix_tax_thumb").val( jQuery("img",html).attr("src") );
                    tb_remove();
                }
	    });
	</script>';
}

// сохраняем наше изображение таксономии при редактировании
function garden_pix_save_tax_thumb($term_id) {
    if (isset($_POST['garden_pix_tax_thumb']))
        update_option('garden_pix_tax_thumb' . $term_id, $_POST['garden_pix_tax_thumb']);
}

// выводим ссылку на изображение таксономии для данного term_id (NULL по-умолчанию)
function garden_pix_tax_thumb_url($term_id = NULL) {
    if ($term_id) 
        return get_option('garden_pix_tax_thumb' . $term_id);
    elseif (is_category())
        return get_option('garden_pix_tax_thumb' . get_query_var('cat')) ;
    elseif (is_tax()) {
        $current_term = get_term_by('slug', get_query_var('term'), get_query_var('taxonomy'));
        return get_option('garden_pix_tax_thumb' . $current_term->term_id);
    }
}

?>