<?php 
/**** THEME SETTINGS ***/

$args = array(
    'post_type'        => 'staticblocks',
    'post_status'      => 'publish',
);
$staticBlocks = array();
$staticFooter = array();
$staticBlocksData = get_posts( $args );
foreach($staticBlocksData as $_block){
    if($_block->post_title == 'Footer')
        $staticFooter[] = array( "value" => $_block->ID, "text" => $_block->post_title);
    else
        $staticBlocks[] = array( "value" => $_block->ID, "text" => $_block->post_title);
}	
$staticBlocks = array_merge ($staticFooter, $staticBlocks);

global $wp_registered_sidebars;

$_sidebars = array();

$sidebars = $wp_registered_sidebars;
if(is_array($sidebars) && !empty($sidebars)){
    foreach($sidebars as $sidebar){
        $_sidebars[] = array('value' => esc_attr($sidebar['id']),'text' => $sidebar['name']);
    }
}

$shortname = 'garden_pix';	
$options = array(

    array(
        'type' => 'open',
        'tab_name' => 'General settings',
        'tab_id' => 'general-settings'
    ) ,

    array(
        'name' => 'Purchase Code',
        'id' => $shortname . '_purchase_code',
        'type' => 'text',
        'std' => '',
        'desc' => '<a href="https://help.market.envato.com/hc/en-us/articles/202822600-Where-Can-I-Find-my-Purchase-Code-">Where Can I Find my Purchase Code?</a>'
    ) ,

    array(
        'name' => 'Templines News',
        'id' => $shortname . '_banner',
        'type' => 'select',
        'desc' => 'Display banner',
        'options' => array(
            array( "value" => "0", "text" => "Hide"),
            array( "value" => "1", "text" => "Show"),
        )
    ) ,

    array(
        'name' => 'Logo image',
        'id' => $shortname . '_logo',
        'type' => 'upload',
        'img_w' => '400',
        'img_h' => '250',
        'std' => '',
        'desc' => 'Upload a logo from your hard drive or specify an existing url'
    ),
/*	
    array(
        'name' => 'Logo inverse image',
        'id' => $shortname . '_logo_inverse',
        'type' => 'upload',
        'img_w' => '400',
        'img_h' => '250',
        'std' => '',
        'desc' => 'Upload a logo from your hard drive or specify an existing url'
    ),

    array(
        'name' => 'Logo mobile image',
        'id' => $shortname . '_logo_mobile',
        'type' => 'upload',
        'img_w' => '400',
        'img_h' => '250',
        'std' => '',
        'desc' => 'Upload a logo from your hard drive or specify an existing url'
    ),
*/
    array(
        'name' => 'Logo Text',
        'id' => $shortname . '_logotext',
        'type' => 'text',
        'std' => '',
        'desc' => 'Logo Image alt text'
    ) ,

    array(
        'name' => 'Favicon',
        'id' => $shortname . '_favicon',
        'type' => 'upload',
        'img_w' => '400',
        'img_h' => '250',
        'std' => '',
        'desc' => 'Upload a favicon.'
    ),

    array(
        'name' => 'Header image',
        'id' => $shortname . '_header_img',
        'type' => 'upload',
        'img_w' => '1600',
        'img_h' => '140',
        'std' => '',
        'desc' => 'Upload an image from your hard drive or specify an existing url (Recommended size: 1600x140)'
    ),

    array(
        'name' => 'Loader',
        'id' => $shortname . '_loader',
        'type' => 'select',
        'desc' => 'Choose loader use',
        'options' => array(
            array( "value" => "0", "text" => "Off"),
            array( "value" => "1", "text" => "Use on main"),
            array( "value" => "2", "text" => "Use on all pages")
        )
    ) ,

    array(
        'name' => 'Responsive',
        'id' => $shortname . '_responsive',
        'type' => 'select',
        'desc' => 'Choose responsive use',
        'options' => array(
            array( "value" => "1", "text" => "On"),
            array( "value" => "0", "text" => "Off")
        )
    ) ,

    array(
        'type' => 'close'
    ) ,
    /*****************************************************/

    /****** Display ****/
    array(
        'type' => 'open',
        'tab_name' => 'Display',
        'tab_id' => 'display'
    ) ,

        array(
            'name' => 'Show Color Scheme Switcher',
            'id' => $shortname . '_color_switcher',
            'type' => 'select',
            'desc' => 'Switch color scheme',
            'options' => array(
                array( "value" => "0", "text" => "Off"),
                array( "value" => "1", "text" => "On")
            )
        ) ,

        array(
            'name' => 'Header Type',
            'id' => $shortname . '_header_type',
            'type' => 'select',
            'desc' => 'Select header type',
            'options' => array(
                array( "value" => "header1", "text" => "Type 1"),
                array( "value" => "header2", "text" => "Type 2"),
                array( "value" => "header3", "text" => "Type 3"),
            )
        ) ,

        array(
            'name' => 'Header Sticky',
            'id' => $shortname . '_header_sticky',
            'type' => 'select',
            'desc' => 'On/off header sticky',
            'options' => array(
                array( "value" => "sticky", "text" => "On"),
                array( "value" => "nosticky", "text" => "Off"),
            )
        ) ,

        array(
            'name' => 'Page Layout',
            'id' => $shortname . '_page_layout',
            'type' => 'select',
            'desc' => 'Wide or boxed',
            'options' => array(
                array( "value" => "wide", "text" => "Wide"),
                array( "value" => "boxed", "text" => "Boxed"),
            )
        ) ,

    array(
        'type' => 'close'
    ) ,

    /*****************************************************/
    
    /*************** HEADER ***************/
    array(
        'type' => 'open',
        'tab_name' => 'Header',
        'tab_id' => 'header-section'
    ) ,

    array(
        'name' => 'Heder Info',
        'id' => $shortname . '_header_info',
        'type' => 'textarea',
        'std' => 'Welcome to Garden Master . Premium Garden Services',
        'height' => '100',
        'desc' => 'information in the header left of site'
    ) ,

    array(
        'name' => 'Heder Phone',
        'id' => $shortname . '_header_phone',
        'type' => 'text',
        'std' => '',
        'desc' => 'Phone information'
    ) ,

    array(
        'name' => 'Heder E-mail',
        'id' => $shortname . '_header_email',
        'type' => 'text',
        'std' => '',
        'desc' => 'E-mail information'
    ) ,

    array(
        'name' => 'Heder Button Text',
        'id' => $shortname . '_header_btntxt',
        'type' => 'text',
        'std' => '',
        'desc' => 'Leave empty to hide button'
    ) ,

    array(
        'name' => 'Heder Button Link',
        'id' => $shortname . '_header_btnlink',
        'type' => 'text',
        'std' => '',
        'desc' => 'Button link'
    ) ,

    array(
        'name' => 'Show Header Top Bar',
        'id' => $shortname . '_header_bar',
        'type' => 'select',
        'desc' => 'On/off header bar',
        'options' => array(
            array( "value" => "1", "text" => "On"),
            array( "value" => "0", "text" => "Off")
        )
    ) ,

    array(
        'name' => 'Show minicart Icon',
        'id' => $shortname . '_header_minicart',
        'type' => 'select',
        'desc' => 'On/off header cart',
        'options' => array(
            array( "value" => "1", "text" => "On"),
            array( "value" => "0", "text" => "Off")
        )
    ) ,

    array(
        'name' => 'Show Search',
        'id' => $shortname . '_header_search',
        'type' => 'select',
        'desc' => 'On/off header search',
        'options' => array(
            array( "value" => "1", "text" => "On"),
            array( "value" => "0", "text" => "Off")
        )
    ) ,

    array(
        'name' => 'Show Socials',
        'id' => $shortname . '_header_socials',
        'type' => 'select',
        'desc' => 'On/off header social icons',
        'options' => array(
            array( "value" => "1", "text" => "On"),
            array( "value" => "0", "text" => "Off")
        )
    ) ,

    array(
        'type' => 'close'
    ) ,
    /*****************************************/    

    /*************** FOOTER ***************/
    array(
        'type' => 'open',
        'tab_name' => 'Footer',
        'tab_id' => 'footer-section'
    ) ,

    array(
        'name' => 'StaticBlock',
        'id' => $shortname . '_footer_staticblock',
        'type' => 'select',
        'desc' => 'Choose staticblock to use',
        'options' => $staticBlocks,
    ) ,

    array(
        'name' => 'Footer Copyright',
        'id' => $shortname . '_footer_copy',
        'type' => 'textarea',
        'std' => '&copy; 2015 Garden Master.&nbsp;&nbsp;Designed By Templines.',
        'height' => '40',
        'desc' => 'site copyright'
    ) ,
    /*
    array(
        'name' => 'Footer Logo image',
        'id' => $shortname . '_footer_logo',
        'type' => 'upload',
        'img_w' => '150',
        'img_h' => '40',
        'std' => '',
        'desc' => 'Upload a logo from your hard drive or specify an existing url (Recommended size: 150x40)'
    ),
    */


    array(
        'type' => 'close'
    ) ,
    /*****************************************/

    /*******************  BLOG  ******************/
    array(
        'type' => 'open',
        'tab_name' => 'Blog',
        'tab_id' => 'blog'
    ) ,
    /*
    array(
        "name" => "Blog Layout",
        "desc" => "Show list or grid posts page.",
        "id" => $shortname."_blog_layout",
        "type" => "select",
        'options' => array(
            array( "value" => "0", "text" => "List"),
            array( "value" => "1", "text" => "Grid")
        )
    ),
    */
    array(
        "name" => "Show date",
        "desc" => "Date on blog posts listing page.",
        "id" => $shortname."_blog_show_date",
        "type" => "select",
        'options' => array(
            array( "value" => "1", "text" => "Yes"),
            array( "value" => "0", "text" => "No")
        )
    ),

    array(
        "name" => "Show share buttons",
        "desc" => "Show share buttons on single post.",
        "id" => $shortname."_blog_share",
        "type" => "select",
        'options' => array(
            array( "value" => "1", "text" => "Yes"),
            array( "value" => "0", "text" => "No")
        )
    ),
    /*
    array(
        "name" => "Show About Author",
        "desc" => "Show About Author block on single post.",
        "id" => $shortname."_blog_show_author",
        "type" => "select",
        'options' => array(
            array( "value" => "1", "text" => "Yes"),
            array( "value" => "0", "text" => "No")
        )
    ),

    array(
        "name" => "Show Author Posts",
        "desc" => "Show Author Posts block on single post.",
        "id" => $shortname."_blog_show_author_posts",
        "type" => "select",
        'options' => array(
            array( "value" => "1", "text" => "Yes"),
            array( "value" => "0", "text" => "No")
        )
    ),
    */
    array(
        "name" => "Show comments",
        "desc" => "Show comments on single post.",
        "id" => $shortname."_blog_show_comments",
        "type" => "select",
        'options' => array(
            array( "value" => "1", "text" => "Yes"),
            array( "value" => "0", "text" => "No")
        )
    ),

    array(
        "name" => "Show Categories",
        "desc" => "Show Categories list.",
        "id" => $shortname."_blog_show_category",
        "type" => "select",
        'options' => array(
            array( "value" => "1", "text" => "Yes"),
            array( "value" => "0", "text" => "No")
        )
    ),

    array(
        "name" => "Show Tags",
        "desc" => "Show Tags list.",
        "id" => $shortname."_blog_show_tag",
        "type" => "select",
        'options' => array(
            array( "value" => "1", "text" => "Yes"),
            array( "value" => "0", "text" => "No")
        )
    ),


    array( "type" => "close"),
    /*********************************************/

    /*************** Woocommerce ***************/
    array(
        'type' => 'open',
        'tab_name' => 'Woocommerce',
        'tab_id' => 'woocommerce-settings'
    ) ,

    array(
        'name' => 'Related Products',
        'id' => $shortname . '_pelated_products',
        'type' => 'text',
        'std' => '3',
        'desc' => 'Related products per page'
    ) ,
    array(
        "name" => "Show share buttons",
        "desc" => "Show share buttons on single product.",
        "id" => $shortname."_product_share",
        "type" => "select",
        'options' => array(
            array( "value" => "1", "text" => "Yes"),
            array( "value" => "0", "text" => "No")
        )
    ),
    array(
        'name' => 'Use global product settings',
        'id' => $shortname . '_use_product_global',
        'type' => 'select',
        'options' => array(
            array( "value" => "0", "text" => "No"),
            array( "value" => "1", "text" => "Yes")
        ),
        'desc' => 'Use global product settings'
    ) ,

    array(
        'name' => 'Sidebar Type on Product Page',
        'id' => $shortname . '_ppage_sidebar_type',
        'type' => 'select',
        'options' => array(
            array( "value" => "1", "text" => "Full width"),
            array( "value" => "3", "text" => "Left"),
            array( "value" => "2", "text" => "Right"),
        ),
        'desc' => 'Sidebar Type on Product Page'
    ) ,

    array(
        'name' => 'Sidebar Content on Product Page',
        'id' => $shortname . '_ppage_sidebar_content',
        'type' => 'select',
        'options' => $_sidebars,
        'desc' => 'Sidebar Content on Product Page'
    ) ,
    array(
        'type' => 'close'
    ) ,
    
    /*****************************************/	

    /*************** Portfolio ***************/
    array(
        'type' => 'open',
        'tab_name' => 'Portfolio',
        'tab_id' => 'portfolio-settings'
    ) ,
    
    array(
        'name' => 'Portfolio Column Number',
        'id' => $shortname . '_portfolio_type',
        'type' => 'select',
        'desc' => 'Portfolio items per row',
        'options' => array(
            array( "value" => "2", "text" => "2"),
            array( "value" => "3", "text" => "3"),
            array( "value" => "4", "text" => "4"),
        )
    ) ,

    array(
        'name' => 'Tumbnails Width',
        'id' => $shortname . '_portfolio_width',
        'type' => 'text',
        'std' => '555',
        'desc' => 'px'
    ) ,

    array(
        'name' => 'Tumbnails Height',
        'id' => $shortname . '_portfolio_height',
        'type' => 'text',
        'std' => '341',
        'desc' => 'px'
    ) ,

    array(
        'type' => 'close'
    ) ,
    
    /*****************************************/

    /**************  SOCIAL  ***************/
    array(
        'type' => 'open',
        'tab_name' => 'Social',
        'tab_id' => 'social'
    ) ,

    array(
        'name' => 'Facebook',
        'id' => $shortname . '_facebook',
        'type' => 'text',
        'std' => '',
        'desc' => ''
    ) ,
    array(
        'name' => 'VK',
        'id' => $shortname . '_vk',
        'type' => 'text',
        'std' => '',
        'desc' => ''
    ) ,
    array(
        'name' => 'Youtube',
        'id' => $shortname . '_youtube',
        'type' => 'text',
        'std' => '',
        'desc' => ''
    ) ,
    array(
        'name' => 'Vimeo',
        'id' => $shortname . '_vimeo',
        'type' => 'text',
        'std' => '',
        'desc' => ''
    ) ,
    array(
        'name' => 'Twitter',
        'id' => $shortname . '_twitter',
        'type' => 'text',
        'std' => '',
        'desc' => ''
    ) ,
    array(
        'name' => 'Google+',
        'id' => $shortname . '_google',
        'type' => 'text',
        'std' => '',
        'desc' => ''
    ) ,
    array(
        'name' => 'Tumblr',
        'id' => $shortname . '_tumblr',
        'type' => 'text',
        'std' => '',
        'desc' => ''
    ) ,
    array(
        'name' => 'Wordpress',
        'id' => $shortname . '_wordpress',
        'type' => 'text',
        'std' => '',
        'desc' => ''
    ) ,
    array(
        'name' => 'Instagram',
        'id' => $shortname . '_instagram',
        'type' => 'text',
        'std' => '',
        'desc' => ''
    ) ,
    array(
        'name' => 'Pinterest',
        'id' => $shortname . '_pinterest',
        'type' => 'text',
        'std' => '',
        'desc' => ''
    ) ,
    array(
        'name' => 'Linkedin',
        'id' => $shortname . '_linkedin',
        'type' => 'text',
        'std' => '',
        'desc' => ''
    ) ,
    array(
        'name' => 'Custom 1 link',
        'id' => $shortname . '_custom1_link',
        'type' => 'text',
        'std' => '',
        'desc' => ''
    ) ,
    array(
        'name' => 'Custom 1 icon',
        'id' => $shortname . '_custom1_icon',
        'type' => 'text',
        'std' => '',
        'desc' => ''
    ) ,
    array(
        'name' => 'Custom 2 link',
        'id' => $shortname . '_custom2_link',
        'type' => 'text',
        'std' => '',
        'desc' => ''
    ) ,
    array(
        'name' => 'Custom 2 icon',
        'id' => $shortname . '_custom2_icon',
        'type' => 'text',
        'std' => '',
        'desc' => ''
    ) ,
    array(
        'name' => 'Custom 3 link',
        'id' => $shortname . '_custom3_link',
        'type' => 'text',
        'std' => '',
        'desc' => ''
    ) ,
    array(
        'name' => 'Custom 3 icon',
        'id' => $shortname . '_custom3_icon',
        'type' => 'text',
        'std' => '',
        'desc' => ''
    ) ,


    array(
        'type' => 'close'
    ) ,
    /*****************************************************/



    /**************  Miscellaneous  ***************/
    array(
        'type' => 'open',
        'tab_name' => 'Custom CSS / JS',
        'tab_id' => 'misc'
    ) ,
        array(
            'name' => 'Custom CSS',
            'id' => $shortname.'_custom_css',
            'type' => 'textarea',
            'std' => '',
            'desc' => 'Add any custom css here. It will override the default values and will not be overwritten when the theme is updated. <br /> e.g.; .region1wrap{background:#000}'
        ),

        array(
            'name' => 'Custom JS',
            'id' => $shortname.'_custom_js',
            'type' => 'textarea',
            'std' => '',
            'desc' => 'Add any custom javascript code, like Google Analytics, here.'
        ),

    array(
        'type' => 'close'
    ) ,
    /*****************************************************/
);

add_action( 'init', 'garden_pix_theme_options', 1 );

function garden_pix_theme_options($return = false) {

    global $options;

    /**
    * Get a copy of the saved settings array.
    */
    $saved_settings = get_option( 'garden_pix_general_settings' );
    $options_array = array();
    foreach($options as $value) {
        if (isset($value['id']) && isset($value['std'])) {
            $options_array[$value['id']] = stripslashes($value['std']);
        }
        elseif(isset($value['id']))
            $options_array[$value['id']] = '';
    }
    //update_option('garden_pix_general_settings', $options_array);


    //print_r($saved_settings);
    //echo "<br>";
    //print_r($options_array);

    if(empty($saved_settings)) {
       update_option( 'garden_pix_general_settings', $options_array );
    }

}


?>