<?php /*** The loop that displays posts.***/ ?>

<?php 

$garden_pix_custom = get_option('page_for_posts') != '' ? get_post_custom(get_option('page_for_posts')) : '';
$garden_pix_layout = isset ($garden_pix_custom['garden_pix_page_layout']) && $garden_pix_custom['garden_pix_page_layout'][0] == '1' ? 3 : 2;
$garden_pix_options = get_option('garden_pix_general_settings');
$i=0;
?>

<?php if ( ! have_posts() ) : ?>
    <div  class="post error404 not-found">
        <h1 class="entry-title"><?php esc_html_e( 'Not Found', 'Garden' ); ?></h1>
        <div class="entry-content">
            <p><?php esc_html_e( 'Apologies, but no results were found for the requested archive. Perhaps searching will help find a related post.', 'Garden' ); ?></p>
            <?php get_search_form(); ?>
        </div><!-- .entry-content -->
    </div><!-- #post-0 -->
<?php endif; ?> 

<?php while ( have_posts() ) : the_post(); ?>
    
    <?php $class_post = $post->post_type != 'post' ? 'post' : ''; ?>      
    <div id="post-<?php esc_attr(the_ID());?>" <?php post_class('blog-post-teaser '.$class_post); ?>>
    <?php  
        $garden_pix_format  = get_post_format();
        $garden_pix_format = !in_array($garden_pix_format, array("quote", "gallery", "video")) ? 'standared' : $garden_pix_format;		
        get_template_part( 'template-parts/post-format/blog', $garden_pix_format);      
        get_template_part( 'template-parts/blog-template/blog', 'template');
    ?>    
    </div>
    <!-- end post -->    

<?php $i++;  endwhile;?>

<div class="pagination-box clearfix">
    <?php 
    if ( $wp_query->max_num_pages > 1 ) :
        include(PIX_funcPATH. 'wp-pagenavi.php' );
        if(function_exists('garden_pix_wp_pagenavi')) { garden_pix_wp_pagenavi();}
    endif;
    ?>
</div>
