<?php

/************* LOAD REQUIRED SCRIPTS AND STYLES *************/
function garden_pix_loadscripts(){
	global $post;
	$garden_pix_options = get_option('garden_pix_general_settings');
	if ($GLOBALS['pagenow'] != 'wp-login.php' && !is_admin()){
		/* MAIN CSS */
		wp_enqueue_style('style', get_stylesheet_uri());
		wp_enqueue_style('pixtheme-woocommerce', get_template_directory_uri() . '/woocommerce/assets/css/woocommerce.css');
		wp_enqueue_style('pixtheme-woocommerce-layout', get_template_directory_uri() . '/woocommerce/assets/css/woocommerce-layout.css');
		if (garden_pix_get_option('garden_pix_responsive','1')){
			wp_enqueue_style('garden_pix-responsive', get_template_directory_uri() . '/css/responsive.css');
		}else{
			wp_enqueue_style('garden_pix-no-responsive', get_template_directory_uri() . '/css/no-responsive.css');
		}
		wp_enqueue_style('garden_pix-debugging', get_template_directory_uri() . '/debugging.css');
		wp_dequeue_style('js_composer_front');
		wp_deregister_style('js_composer_front');
		wp_enqueue_style('garden_pix_composer-css', get_template_directory_uri() . '/css/js_composer.css');
		
		
		// Loader
		if( (garden_pix_get_option('garden_pix_loader','1') == 1 && is_front_page()) || garden_pix_get_option('garden_pix_loader','1') == 2){
			
		}


		/* PRIMARY CSS */
		wp_enqueue_style('garden_pix-master', get_template_directory_uri() . '/css/master.css');
		wp_enqueue_style('garden_pix-debugging', get_template_directory_uri() . 'debugging.css');
		
		
		/* PLUGIN CSS */
		wp_enqueue_style('garden_pix-owl', get_template_directory_uri() . '/assets/owl-carousel/owl.carousel.css');
		wp_enqueue_style('garden_pix-owltheme', get_template_directory_uri() . '/assets/owl-carousel/owl.theme.css');
		wp_enqueue_style('garden_pix-owltransitions', get_template_directory_uri() . '/assets/owl-carousel/owl.transitions.css');
		wp_enqueue_style('garden_pix-prettyphoto', get_template_directory_uri() . '/assets/prettyphoto/css/prettyPhoto.css');
		wp_enqueue_style('garden_pix-yamm/', get_template_directory_uri() . '/assets/yamm/yamm.css');
		wp_enqueue_style('garden_pix-isotope', get_template_directory_uri() . '/assets/isotope/isotope.css');
		wp_enqueue_style('garden_pix-dynamic-styles', get_template_directory_uri() . '/css/dynamic-styles.php');


		if(isset($_GET['get_scheme'])){
			$wp_session['color-scheme'] = $_GET['get_scheme'];
			wp_enqueue_style('garden_pix-color-scheme', get_template_directory_uri() . '/assets/switcher/css/'.$wp_session['color-scheme'].'.css');
		}
		elseif(!empty($wp_session['color-scheme'])){
			wp_enqueue_style('garden_pix-color-scheme', get_template_directory_uri() . '/assets/switcher/css/'.$wp_session['color-scheme'].'.css');
		}
		elseif (garden_pix_get_option('garden_pix_color_switcher','0') == 0 && !isset($_GET['get_scheme']) && !isset($wp_session['color-scheme'])) {
			if(isset($post->ID) && $post->ID>0 && get_post_meta($post->ID, 'color_sheme', 1) != ''){
				wp_enqueue_style('garden_pix-color-scheme', get_template_directory_uri() . '/assets/switcher/css/'.get_post_meta($post->ID, 'color_sheme', 1).'.css');
			}else{
            	wp_enqueue_style('garden_pix-color-scheme', get_template_directory_uri() . '/assets/switcher/css/'.garden_pix_get_option('garden_pix_color_scheme','color1').'.css');
			}
        }
		

		// jQuery
		wp_enqueue_script('garden_pix-migrate', get_template_directory_uri() . '/js/jquery-migrate-1.2.1.min.js', array() , '3.3', true);
		wp_enqueue_script('garden_pix-jquery-ui', get_template_directory_uri() . '/js/jquery-ui.min.js', array() , '3.3', true);


		// Bootstrap Core JavaScript
		wp_enqueue_script('garden_pix-bootstrap', get_template_directory_uri() . '/js/bootstrap.min.js', array() , '3.3', true);
		wp_enqueue_script('garden_pix-modernizr', get_template_directory_uri() . '/js/modernizr.js');


		// User agent
		wp_enqueue_script('garden_pix-cssua', get_template_directory_uri() . '/js/cssua.min.js', array() , '3.3', true);
		
		
		// User highcharts
		wp_enqueue_script('garden_pix-highcharts', get_template_directory_uri() . '/assets/js/highcharts.js', array() , '1.0', true);
		wp_enqueue_script('garden_pix-tweenmax', get_template_directory_uri() . '/assets/js/TweenMax.min.js', array() , '1.0', true);


		// Waypoint
		wp_enqueue_script('garden_pix-waypoints', get_template_directory_uri() . '/js/waypoints.min.js', array() , '3.3', true);
			
		
		// Isotope filter
		wp_enqueue_script('isotope', get_template_directory_uri() . '/assets/isotope/jquery.isotope.min.js', array() , '3.3', true);
		wp_enqueue_script('masonry', get_template_directory_uri() . '/assets/events/masonry.pkgd.min.js', array() , '3.3', true);
		wp_enqueue_script('garden_pix-easing', get_template_directory_uri() . '/js/jquery.easing.min.js', array() , '3.3', true);
		wp_enqueue_script('garden_pix-easypiechart', get_template_directory_uri() . '/js/jquery.easypiechart.js', array() , '3.3', true);

		// Ios Fix
		wp_enqueue_script('garden_pix-ios-orientationchange-fix', get_template_directory_uri() . '/js/ios-orientationchange-fix.js', array() , '3.3', true);


		// Owl Carousel
		wp_enqueue_script('garden_pix-owl-carousel', get_template_directory_uri() . '/assets/owl-carousel/owl.carousel.min.js', array() , '3.3', true);
		
		
	 // Flex Carousel
		wp_enqueue_script('garden_pix-flexslider', get_template_directory_uri() . '/assets/flexslider/jquery.flexslider-min.js', array() , '1.3', true);
		wp_enqueue_style('garden_pix-flexslidercss/', get_template_directory_uri() . '/assets/flexslider/flexslider.css');
		
		
		
		// Pretty Photo
		wp_enqueue_script('garden_pix-prettyphoto', get_template_directory_uri() . '/assets/prettyphoto/js/jquery.prettyPhoto.js', array() , '3.3', true);
		
			wp_enqueue_script('garden_pix-doubletaptogo', get_template_directory_uri() . '/js/doubletaptogo.js', array() , '1.1', true);
		
		
		
		// Isotope filter		
		 wp_enqueue_script('garden_pix-pricing-tables', get_template_directory_uri() . '/assets/pricing-tables/js/main.js', array() , '3.3', true);
	     wp_enqueue_style('garden_pix-pricing-tables-styles', get_template_directory_uri() . '/assets/pricing-tables/css/style.css');


		// Element form Styled
		//wp_enqueue_script('garden_pix-selectbox', get_template_directory_uri() . '/assets/selectbox/jquery.selectbox-0.2.js', array() , '0.2', true);


		// Sly Slider
		wp_enqueue_script('garden_pix-sly', get_template_directory_uri() . '/assets/sly/sly.min.js', array() , '3.3', true);


		// Switcher
		wp_enqueue_script('garden_pix-bootstrap-select', get_template_directory_uri() . '/assets/switcher/js/bootstrap-select.js', array(), '3.3', true);
		wp_enqueue_script('garden_pix-colorpicker-evol', get_template_directory_uri() . '/assets/switcher/js/evol.colorpicker.min.js', array(), '3.3', true);
		wp_enqueue_script('garden_pix-dmss-js', get_template_directory_uri() . '/assets/switcher/js/dmss.js', array(), '3.3', true);
		wp_enqueue_style('garden_pix-css-switcher', get_template_directory_uri() . '/assets/switcher/css/switcher.css');


		// flickrfeed
		wp_enqueue_script('garden_pix-flickrfeed', get_template_directory_uri() . '/assets/jflickrfeed/jflickrfeed.min.js', array() , '3.3', true);
		wp_enqueue_script('garden_pix-footer', get_template_directory_uri() . '/js/scripts.js', array() , '3.3', true);
		wp_register_script('garden_pix_carousel_js', get_template_directory_uri() . '/js/jquery.flexslider-min.js', array() , '3.3', true);
		wp_register_style('garden_pix_carousel_css', get_template_directory_uri() . '/js/flexslider.css');

	}
}

add_action('wp_enqueue_scripts', 'garden_pix_loadscripts'); //Load All Scripts


function garden_pix_dynamic_stylesheet() {

	global $wp_query, $post;
	$fpost = $footerBlockId = $footpost = $shortcodes_custom_css = '';
	$fpost = isset ($wp_query) ? $wp_query->get_queried_object_id() : (isset($post->ID) && $post->ID>0 ? $post->ID : '');
	$footerBlockId = in_array(get_post_meta($fpost, 'garden_pix_footer_staticblock', true), array("global", "")) || $fpost == '' ? garden_pix_get_option('garden_pix_footer_staticblock') : get_post_meta($fpost, 'garden_pix_footer_staticblock', true);
	$footpost = get_post( $footerBlockId );

	if ($footerBlockId) {
		$shortcodes_custom_css = get_post_meta( $footpost->ID, '_wpb_shortcodes_custom_css', true );
		if ( ! empty( $shortcodes_custom_css ) ) {
			echo '<style type="text/css" data-type="vc_shortcodes-custom-css">';
			echo esc_html($shortcodes_custom_css);
			echo '</style>';
		}
	}
}

add_action('wp_head', 'garden_pix_dynamic_stylesheet');


function garden_pix_load_custom_wp_admin_style(){
	wp_register_script('custom_wp_admin_script', get_template_directory_uri() . '/js/custom-admin.js', false, '1.0.0');
	wp_enqueue_script('custom_wp_admin_script');
}

add_action('admin_enqueue_scripts', 'garden_pix_load_custom_wp_admin_style');


function garden_pix_add_editor_styles() {
	add_editor_style( get_template_directory_uri() . '/css/editor_styles.css' );
}

add_action( 'current_screen', 'garden_pix_add_editor_styles' );
/************************************************************/

?>