<?php

if(file_exists(get_template_directory() .'/one-click-demo-install/init.php'))
	require get_template_directory() .'/one-click-demo-install/init.php';

function garden_pix_extended_upload ( $mime_types =array() ) { 
   // The MIME types listed here will be allowed in the media library.
   // You can add as many MIME types as you want.
   $mime_types['gz']  = 'application/x-gzip';
   $mime_types['zip']  = 'application/zip';
   return $mime_types;
}
 
add_filter('upload_mimes', 'garden_pix_extended_upload');


if (is_admin() && isset($_GET['activated'])){
	wp_redirect(admin_url('admin.php?page=adminpanel'));
	unregister_sidebar('header-sidebar');
}

/*************** AFTER THEME SETUP FUNCTIONS ****************/
add_action('after_setup_theme', 'garden_pix_setup');

function garden_pix_setup(){
	
	global $garden_pix_options;
	
	// Language support

	load_theme_textdomain('Garden', get_template_directory() . '/languages');
	$locale = get_locale();
	$locale_file = get_template_directory() . "/languages/$locale.php";
	if (is_readable($locale_file)){
		require_once ($locale_file);
	}

	// ADD SUPPORT FOR POST THUMBS

	add_theme_support('post-thumbnails');

	// Define various thumbnail sizes

	$width = (!empty($garden_pix_options['garden_pix_portfolio_width'])) ? $garden_pix_options['garden_pix_portfolio_width'] : 555;
	$height = (!empty($garden_pix_options['garden_pix_portfolio_height'])) ? $garden_pix_options['garden_pix_portfolio_height'] : 341;
	$width_t = 192;
	$height_t = 192;
	add_image_size('garden_pix-post-thumb', 370, 230, true);
	add_image_size('garden_pix-portfolio-thumb', $width_t, $height_t, true);
	add_image_size('garden_pix-portfolio-thumb-2x', $width_t * 2, $height_t, true);
	add_image_size('garden_pix-portfolio-thumb-2y', $width_t, $height_t * 2, true);
	add_image_size('garden_pix-portfolio-thumb-2xy', $width_t * 2, $height_t * 2, true);
	add_image_size('garden_pix-portfolio-thumb-col2', $width, $height, true);
	add_image_size('garden_pix-preview-thumb', 100, 100, true);
	add_theme_support('title-tag');
	add_theme_support('automatic-feed-links');
	add_theme_support('post-formats', array(
		'gallery',
		'video',
		'quote',
	));

	// ADD SUPPORT FOR WORDPRESS 3 MENUS ************/

	add_theme_support('menus');

	// Register Navigations

	add_action('init', 'garden_pix_custom_menus');
	function garden_pix_custom_menus()	{
		register_nav_menus(array(
			'primary_nav' => esc_html__('Primary Navigation', 'Garden') ,
			'top_nav' => esc_html__('Top Navigation', 'Garden') ,
			'footer_nav' => esc_html__('Footer Navigation', 'Garden')
		));
	}
}

$args = array(
	'flex-width' => true,
	'width' => 350,
	'flex-height' => true,
	'height' => 'auto',
	'default-image' => get_template_directory_uri() . '/images/logo.jpg'
);
add_theme_support('custom-header', $args);
$args = array(
	'default-color' => 'FFFFFF'
);
add_theme_support('custom-background', $args);

/************************************************************/

/**
 * Filter whether comments are open for a given post type.
 *
 * @param string $status       Default status for the given post type,
 *                             either 'open' or 'closed'.
 * @param string $post_type    Post type. Default is `post`.
 * @param string $comment_type Type of comment. Default is `comment`.
 * @return string (Maybe) filtered default status for the given post type.
 */
function garden_pix_open_comments_for_page( $status, $post_type, $comment_type ) {
    if ( 'page' === $post_type ) {
        return 'open';
    }

    // You could be more specific here for different comment types if desired
    return $status;
}
add_filter( 'get_default_comment_status', 'garden_pix_open_comments_for_page', 10, 3 );


function garden_pix_wp_get_attachment( $attachment_id ) {
	$attachment = get_post( $attachment_id );
	return array(
		'alt' => get_post_meta( $attachment->ID, '_wp_attachment_image_alt', true ),
		'caption' => $attachment->post_excerpt,
		'description' => $attachment->post_content,
		'href' => get_permalink( $attachment->ID ),
		'src' => $attachment->guid,
		'title' => $attachment->post_title
	);
}

?>