<?php
/**
 * The template includes blog post format gallery.
 *
 * @package Pix-Theme
 * @since 1.0
 */
$garden_pix_options = get_option('garden_pix_general_settings');	
    // get the gallery images
    $size = (is_front_page()) && !is_home() ? 'portfolio-3col' : 'blog-post';
    $gallery = class_exists( 'RW_Meta_Box' ) ? rwmb_meta('post_gallery', 'type=image&size='.$size.'') : '';
 
    $argsThumb = array(
        'order'          => 'ASC',
        'post_type'      => 'attachment',
        'post_parent'    => $post->ID,
        'post_mime_type' => 'image',
        'post_status'    => null,
        //'exclude' => get_post_thumbnail_id()
    );
    $attachments = get_posts($argsThumb);
?>

    <div class="wrap-media image-blog-post-block">
    
<?php if ($gallery || $attachment) : ?>   
        <div class="carousel-post">
        <?php
            if($gallery){
                foreach ($gallery as $slide) {
                    echo '<div>';
                    echo '<img src="' . esc_url($slide['url']) . '" width="' . esc_attr($slide['width']) . '" height="' . esc_attr($slide['height']) . '" alt="' .esc_attr($slide['alt']).'" title="' .esc_attr($slide['title']). '" />';
                    echo '</div>';
                }
            }elseif ($attachments) {
                foreach ($attachments as $attachment) {
                    echo '<div><img src="'.esc_url(wp_get_attachment_url($attachment->ID, 'full', false, false)).'" alt="'.esc_attr(get_post_meta($attachment->ID, '_wp_attachment_image_alt', true)).'" title="'.esc_attr(get_post_meta($attachment->ID, '_wp_attachment_image_title', true)).'" /></div>';
                }
            }
?>
        </div>
<?php else: ?>
    <?php if ( has_post_thumbnail() ):?>
    <?php the_post_thumbnail(); ?>
    <?php else : ?>
    <img src="<?php echo esc_url(get_template_directory_uri()) ?>/images/noimage.jpg" alt="noimage" />
    <?php the_post_thumbnail(); ?>
    <?php endif; ?>
<?php endif; ?>
    <?php if(garden_pix_get_option('garden_pix_blog_show_date', '1')): ?>
        <span class="date-post"><?php echo get_the_time('j'); ?> <span><?php echo get_the_time('M'); ?></span></span>
    <?php endif?>
</div>
