<?php
/**
 * Single Product Image
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.0.14
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $post, $woocommerce, $product;

?>

<div class="clearfix" id="image-block">
<?php if ($product->product_type != 'variable') : ?>
	<div id="slider-product" class="flexslider">
    	<ul class="slides">
<?php else : ?>
	<div class="images pix-variable-image">
<?php endif; ?>
       
       <?php
	       
	    $attachment_ids = $product->get_gallery_attachment_ids();
	    
		if ( has_post_thumbnail() && !$attachment_ids ) {

			$image_title 		= esc_attr( get_the_title( get_post_thumbnail_id() ) );
			$image_link  		= wp_get_attachment_url( get_post_thumbnail_id() );
			$image       		= get_the_post_thumbnail( $post->ID, apply_filters( 'single_product_large_thumbnail_size', 'shop_single' ), array(
				'title' => $image_title
				) );
			
			echo apply_filters( 'woocommerce_single_product_image_html', sprintf( '<li><a class="woocommerce-main-image zoom" rel="prettyPhoto[gallery1]" href="%s">%s</a></li>', $image_link, $image ), $post->ID );
			
		} elseif($attachment_ids) {
			$i=0;
			foreach ( $attachment_ids as $attachment_id ) {

				$image_link = wp_get_attachment_url( $attachment_id );
	
				$image       = wp_get_attachment_image( $attachment_id, apply_filters( 'single_product_small_thumbnail_size', 'shop_single' ) );
				$image_class = '';
				$image_title = esc_attr( get_the_title( $attachment_id ) );
				
				if($i==0){
					echo apply_filters( 'woocommerce_single_product_image_html', sprintf( '<li><a rel="prettyPhoto[gallery1]" class="woocommerce-main-image zoom" href="%s">%s</a></li>', $image_link, $image ), $post->ID );
				}else{
					echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', sprintf( '<li><a rel="prettyPhoto[gallery1]" class="woocommerce-main-image zoom" href="%s" title="%s" >%s</a></li>', $image_link, $image_title, $image ), $attachment_id, $post->ID, $image_class );
				}
				$i++;
			}

		} else {

			echo apply_filters( 'woocommerce_single_product_image_html', sprintf( '<li><a rel="prettyPhoto" class="woocommerce-main-image zoom" href="%s"><img src="%s" alt="Placeholder" /></a></li>', woocommerce_placeholder_img_src() ), $post->ID );

		}
	?>
<?php if ($product->product_type != 'variable') : ?>
		</ul>
	</div>
<?php else : ?>
	</div>
<?php endif; ?>
	
	<?php do_action( 'woocommerce_product_thumbnails' ); ?>
    
</div>
