<?php
/**
 * Single Product tabs
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.4.0
 */
global $product;
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Filter tabs and allow third parties to add their own
 *
 * Each tab is an array containing title, callback and priority.
 * @see woocommerce_default_product_tabs()
 */
$tabs = apply_filters( 'woocommerce_product_tabs', array() );

if ( ! empty( $tabs ) ) : ?>

	<div class="woocommerce-tabs tabpanel">
		<ul class="tabs nav nav-tabs">
			<?php foreach ( $tabs as $key => $tab ) : ?>

				<li class="<?php echo esc_attr($key) ?>_tab">
					<a href="#tab-<?php echo esc_attr($key) ?>"><span><i class="fa flaticon-wrench44"></i><?php echo apply_filters( 'woocommerce_product_' . $key . '_tab_title', $tab['title'], $key ) ?></span></a>
				</li>

			<?php endforeach; ?>
		</ul>
		<?php foreach ( $tabs as $key => $tab ) : ?>

			<div class="panel entry-content" id="tab-<?php echo esc_attr($key) ?>">
				<?php call_user_func( $tab['callback'], $key, $tab ) ?>
			</div>

		<?php endforeach; ?>
	</div>

<?php
$pix_productBlockIds = get_post_meta($product->id, '_static_bottom', true);
$pix_productBlockIdsExploded = explode(',', $pix_productBlockIds);
foreach($pix_productBlockIdsExploded as $_pix_productBlockId){
	$productpost = get_post( $_pix_productBlockId );
	$shortcodes_custom_css = get_post_meta( $productpost->ID, '_wpb_shortcodes_custom_css', true );
	if ( ! empty( $shortcodes_custom_css ) ) {
		echo '<style type="text/css" data-type="vc_shortcodes-custom-css">';
		echo esc_html($shortcodes_custom_css);
		echo '</style>';
	}
}
		
?>

<?php endif; ?>
