<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $count
 * @var $disable_carousel
 * @var $css_animation
 * Shortcode class
 * @var $this WPBakeryShortCode_Section_Reviews
 */
global $post; 
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$garden_pix_options = get_option('garden_pix_general_settings');
$disable_carousel = $disable_carousel == 1 ? 'owl-carousel  enable-owl-carousel' : '';
$type_id = $type == 1 ? 'post-owl' : 'owl-team';

$out = $css_animation != '' ? '<div class="home-1-blog-post animated" data-animation="' . esc_attr($css_animation) . '">' : '<div class="home-1-blog-post">';	   

$args = array(
            'ignore_sticky_posts' => true,
        );
if( is_numeric($count)  )
    $args['showposts'] = $count;
else
    $args['numberposts'] = -1;

$wp_query = new WP_Query( $args );

    if ($wp_query->have_posts()):
        $i=0;
        $cnt = $wp_query->post_count;
        $out .= '<div id="'.esc_attr($type_id).'" class="'.esc_attr($disable_carousel).' owl-theme" data-min-slides="'.esc_attr($type).'">';

        while ($wp_query->have_posts()) :
            $wp_query->the_post();
            $custom = get_post_custom($post->ID);
            $i++;
            $date = $cat = '';
            /*
            $get_avatar = get_avatar(get_the_author_meta('ID'), 85);
            preg_match("/src=['\"](.*?)['\"]/i", $get_avatar, $matches);
            $src = !empty($matches[1]) ? $matches[1] : '';
            */
            $garden_pix_format  = get_post_format();
            $garden_pix_format = !in_array($garden_pix_format, array("quote", "gallery", "video")) ? "standared" : $garden_pix_format;
            $icon = array("standared" => "icon_image", "quote" => "icon_pencil_alt", "gallery" => "icon_image", "video" => "icon_film");

            if(garden_pix_get_option('garden_pix_blog_show_category', '1') == 1){
                $categories = get_the_category($post->ID);
                if($categories){
                    $cat = '<li>';
                    foreach($categories as $category) {
                        $cat .= '<a href="'.esc_url(get_category_link( $category->term_id )).'" >'.wp_kses_post($category->cat_name).'</a> ';
                    }
                    $cat .= '</li>';
                }
            }
            if(garden_pix_get_option('garden_pix_blog_show_tag', '1') == 1){
                $posttags = get_the_tags($post->ID);
                if ($posttags) {
                    $tags = '<li>';
                    foreach($posttags as $tag) {
                        $tags .= '<a href="'.esc_url(get_tag_link( $tag->term_id )).'" >'.wp_kses_post($tag->name).'</a> ';
                    }
                    $tags .= '</li>';
                    //echo wp_kses_post($tags);
                }
            }

            if(garden_pix_get_option('garden_pix_blog_show_date', '1')){
                if($type == 1){
                    $date = '<li>'.wp_kses_post(get_the_time('j F Y')).'</li>';
                }else{
                    $date = '<span class="date-post">'.wp_kses_post(get_the_time('j')).' <span>'.wp_kses_post(get_the_time('M')).'</span></span>';
                }
            }
            $thumbnail = get_the_post_thumbnail( $post->ID ) != '' ? get_the_post_thumbnail( $post->ID, 'garden_pix-post-thumb' ) : '<img src="'.esc_url(get_template_directory_uri()).'/images/noimage.jpg" alt="noimage">';


            if($type == 1){

                $out .= '
                <div class="item">
                    <div class="b-post-box">
                        <div class="b-post-image">
                            <a href="'.esc_url(get_the_permalink()).'">'.$thumbnail.'</a>
                            <div class="post-icon">
                                <span class="ef '.esc_attr($icon[$garden_pix_format]).'"></span>
                            </div>
                        </div>
                        <div class="b-p-box">
                            <h4>'.wp_kses_post(get_the_title()).'</h4>
                            <div class="info-box">
                                <ul>
                                    <li>
                                        '.__('By ', 'Garden').get_the_author_link().'
                                    </li>
                                    '.wp_kses_post($cat);
                if( 'open' == $post->comment_status && garden_pix_get_option('garden_pix_blog_show_comments', '1')) {
                $out .= '<li><a href="'.esc_url(get_comments_link( $post->ID )).'">'.__( 'Comments: ', 'Garden' ).wp_kses_post(get_comments_number()).'</a></li>';
                }
                $out .= '
                                    '.$date.'
                                </ul>
                            </div>
                            <div class="b-p-content">
                                '.get_the_excerpt().'
                            </div>
                        </div>
                    </div>
                </div>
                ';

            }else{

                $out .= '
                    <div class="item">
                        <div class="team-img h-post-image">
                            <a href="'.esc_url(get_the_permalink()).'">'.$thumbnail.'</a>
                            '.$date.'
                            <div class="post-icon">
                                <span class="ef '.esc_attr($icon[$garden_pix_format]).'"></span>
                            </div>
                        </div>
                        <div class="team-info-block">
                            <h4>'.wp_kses_post(get_the_title()).'</h4>
                            <div class="info-box">
                                <ul>
                                    <li>
                                        '.get_the_author_link().'
                                    </li>
                                    '.wp_kses_post($cat);
                if( 'open' == $post->comment_status && garden_pix_get_option('garden_pix_blog_show_comments', '1')) {
                $out .= '<li><a href="'.esc_url(get_comments_link( $post->ID )).'">'.__( 'Comments: ', 'Garden' ).wp_kses_post(get_comments_number()).'</a></li>';
                }
                $out .= '
                                </ul>
                            </div>
                            '.get_the_excerpt().'
                        </div>
                    </div>
                ';
            }

         endwhile;

$out .= '</div>';

    endif;

$out .= '            
        <!--end-->
    </div>
    ';

echo $out;