<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 * @var $full_width
 * @var $full_height
 * @var $content_placement
 * @var $parallax
 * @var $parallax_image
 * @var $css
 * @var $el_id
 * @var $video_bg
 * @var $video_bg_url
 * @var $video_bg_parallax
 * @var $content - shortcode content
	$pbgslides
	$pdecor
	$panchor
	$picon
	$ptextcolor
	$ppadding
	
	$bg_row_overflow	
	$bg_pix_image_parallax
	$bg_image_left
	$bg_imgl_top_bottom
	$bg_imgl_vpos
	$bg_imgl_left_right
	$bg_imgl_hpos
	$bg_image_right
	$bg_imgr_top_bottom
	$bg_imgr_vpos
	$bg_imgr_left_right
	$bg_imgr_hpos
	
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_Row
 */
$output = $after_output = $class_slider = $pix_bg_class = $pix_bg_color = $garden_pix_bg_image_left_div = $garden_pix_bg_image_right_div = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );
if(function_exists('fil_init')){
	$picon = isset( ${"icon_" . $type} ) ? ${"icon_" . $type} : '';
}
wp_enqueue_script( 'wpb_composer_front_js' );

/////////////////////////////////////////////
$garden_pix_slider = class_exists( 'RW_Meta_Box' ) ? rwmb_meta('sequence_upload', 'type=image&size=full') : '';
/*
$garden_pix_slides = explode(",", $pbgslides);
$out_slider = "";
foreach($garden_pix_slides as $slide) {
	$att_arr = wp_get_attachment_image_src($slide,'full');
	if (isset($att_arr[0])){
		$att = $att_arr[0];
		$out_slider .= '<li><div style="background-image:url(' . esc_url($att) . ')" class="bg-slide"></div></li>';					
	}
}
$class_slider = $out_slider != '' ? 'bg-slideshow-active' : '';
*/
$class_preset_text = ($ptextcolor) ? ' text-'.strtolower($ptextcolor) : '';
if ($ptextcolor == "Default")
	$class_preset_text = "";

/// bg_image

$garden_pix_bg_image_left_id = preg_replace( '/[^\d]/', '', $bg_image_left );
$garden_pix_bg_image_left_src = wp_get_attachment_image_src( $garden_pix_bg_image_left_id, 'full' );
if ( ! empty( $garden_pix_bg_image_left_src[0] ) ) {
	$garden_pix_image_meta = '';
	$garden_pix_bg_image_left_src = $garden_pix_bg_image_left_src[0];
	$garden_pix_image_meta = garden_pix_wp_get_attachment($garden_pix_bg_image_left_id);
	$garden_pix_image_alt = $garden_pix_image_meta['alt'] == '' ? $garden_pix_image_meta['title'] : $garden_pix_image_meta['alt'];

	$garden_pix_bg_style = $bg_imgl_vpos != '' ? $bg_imgl_top_bottom.':'.$bg_imgl_vpos.'px;' : '';
	$garden_pix_bg_style .= $bg_imgl_hpos != '' ? $bg_imgl_left_right.':'.$bg_imgl_hpos.'px;' : '';
	$garden_pix_bg_image_left_div = '<div class="pix-bg-image-left" style="'.$garden_pix_bg_style.'"><img src="'.esc_url($garden_pix_bg_image_left_src).'" alt="'.esc_attr($garden_pix_image_alt).'"></div>'."\n";
}
$garden_pix_bg_image_right_id = preg_replace( '/[^\d]/', '', $bg_image_right );
$garden_pix_bg_image_right_src = wp_get_attachment_image_src( $garden_pix_bg_image_right_id, 'full' );
if ( ! empty( $garden_pix_bg_image_right_src[0] ) ) {
	$garden_pix_image_meta = '';
	$garden_pix_bg_image_right_src = $garden_pix_bg_image_right_src[0];
	$garden_pix_image_meta = garden_pix_wp_get_attachment($garden_pix_bg_image_right_id);
	$garden_pix_image_alt = $garden_pix_image_meta['alt'] == '' ? $garden_pix_image_meta['title'] :$garden_pix_image_meta['alt'];

	$garden_pix_bg_style = $bg_imgr_vpos != '' ? $bg_imgr_top_bottom.':'.$bg_imgr_vpos.'px;' : '';
	$garden_pix_bg_style .= $bg_imgr_hpos != '' ? $bg_imgr_left_right.':'.$bg_imgr_hpos.'px;' : '';
	$garden_pix_bg_image_right_div = '<div class="pix-bg-image-right" style="'.$garden_pix_bg_style.'"><img src="'.esc_url($garden_pix_bg_image_right_src).'" alt="'.esc_attr($garden_pix_image_alt).'"></div>'."\n";
}


/////////////////////////////////////////////

$el_class = $this->getExtraClass( $el_class );

$css_classes = array(
	'vc_row',
	'wpb_row', //deprecated
	'vc_row-fluid',
	$el_class,
	$ppadding,
	$bg_row_overflow,
	$class_preset_text,
	$class_slider,
	vc_shortcode_custom_css_class( $css ),
);
$wrapper_attributes = array();
// build attributes for wrapper
if ( ! empty( $el_id ) ) {
	$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
}
if ( ! empty( $full_width ) ) {
	$wrapper_attributes[] = 'data-vc-full-width="true"';
	$wrapper_attributes[] = 'data-vc-full-width-init="false"';
	if ( 'stretch_row_content' === $full_width ) {
		$wrapper_attributes[] = 'data-vc-stretch-content="true"';
	} elseif ( 'stretch_row_content_no_spaces' === $full_width ) {
		$wrapper_attributes[] = 'data-vc-stretch-content="true"';
		$css_classes[] = 'vc_row-no-padding';
	}
	$after_output .= '<div class="vc_row-full-width"></div>';
}

if ( ! empty( $full_height ) ) {
	$css_classes[] = ' vc_row-o-full-height';
	if ( ! empty( $content_placement ) ) {
		$css_classes[] = ' vc_row-o-content-' . $content_placement;
	}
}

// use default video if user checked video, but didn't chose url
if ( ! empty( $video_bg ) && empty( $video_bg_url ) ) {
	$video_bg_url = 'https://www.youtube.com/watch?v=lMJXxhRFO1k';
}

$has_video_bg = ( ! empty( $video_bg ) && ! empty( $video_bg_url ) && vc_extract_youtube_id( $video_bg_url ) );

if ( $has_video_bg ) {
	$parallax = $video_bg_parallax;
	$parallax_image = $video_bg_url;
	$css_classes[] = ' vc_video-bg-container';
	wp_enqueue_script( 'vc_youtube_iframe_api_js' );
}

if ( ! empty( $parallax ) ) {
	wp_enqueue_script( 'vc_jquery_skrollr_js' );
	$wrapper_attributes[] = 'data-vc-parallax="1.5"'; // parallax speed
	$css_classes[] = 'vc_general vc_parallax vc_parallax-' . $parallax;
	if ( strpos( $parallax, 'fade' ) !== false ) {
		$css_classes[] = 'js-vc_parallax-o-fade';
		$wrapper_attributes[] = 'data-vc-parallax-o-fade="on"';
	} elseif ( strpos( $parallax, 'fixed' ) !== false ) {
		$css_classes[] = 'js-vc_parallax-o-fixed';
	}
}

if ( ! empty ( $parallax_image ) ) {
	if ( $has_video_bg ) {
		$parallax_image_src = $parallax_image;
	} else {
		$parallax_image_id = preg_replace( '/[^\d]/', '', $parallax_image );
		$parallax_image_src = wp_get_attachment_image_src( $parallax_image_id, 'full' );
		if ( ! empty( $parallax_image_src[0] ) ) {
			$parallax_image_src = $parallax_image_src[0];
		}
	}
	$wrapper_attributes[] = 'data-vc-parallax-image="' . esc_attr( $parallax_image_src ) . '"';
}
if ( ! $parallax && $has_video_bg ) {
	$wrapper_attributes[] = 'data-vc-video-bg="' . esc_attr( $video_bg_url ) . '"';
}
$css_class = preg_replace( '/\s+/', ' ', apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, implode( ' ', array_filter( $css_classes ) ), $this->settings['base'], $atts ) );
$wrapper_attributes[] = 'class="' . esc_attr( trim( $css_class ) ) . '"';

$output .= '<div class="vc_row_anchor js_stretch_anchor">';
if( $panchor == "Yes" && isset( $el_id ) && ! empty( $el_id ) ) { 
	if(function_exists('fil_init') && $picon != ''){
		$output .= '
		<div class="wrap-anchor">
			<a href="#'.esc_attr( $el_id ).'"><div class="top-icon-block icon-image"><i class="'.esc_attr( $picon ).'"></i></div></a>
		</div>';
	}else{
		$output .= '
		<div class="wrap-anchor">
			<a href="#'.esc_attr( $el_id ).'"><div class="top-icon-block"></div></a>
		</div>';
	}
	
}elseif( function_exists('fil_init') && $picon != '' ){
	$output .= '<div class="wrap-anchor"><div class="top-icon-block icon-image"><i class="'.esc_attr( $picon ).'"></i></div></div>';	
}
$output .= '</div>';

$output .= '<div ' . implode( ' ', $wrapper_attributes ) . '>';


/*
if ( !empty( $out_slider ) ){
	$output .= '<ul class="bg-slideshow">'.$out_slider.'</ul>';
}

if (empty( $full_width ) && $this->settings( 'base' ) !== 'vc_row_inner' && is_page_template('fullwidth.php') ){
	$output .= '<div class="container">';
}
*/
$output .= wpb_js_remove_wpautop( $content );
/*
if (empty( $full_width ) && $this->settings( 'base' ) !== 'vc_row_inner' && is_page_template('fullwidth.php') ){
	$output .= '</div>';
}
*/
$output .= $garden_pix_bg_image_left_div != '' || $garden_pix_bg_image_right_div != '' ? '<div class="pix-bg-image-wrapper '.esc_attr($bg_pix_image_parallax).'">'.$garden_pix_bg_image_left_div.$garden_pix_bg_image_right_div.'</div>' : '';

if( $pdecor == "Yes" ){
	preg_match_all( '/{([^\}]+)/i', $css, $matches, PREG_OFFSET_CAPTURE );
	if(isset($matches[1][0][0])){
		foreach( explode( ';', $matches[1][0][0] ) as $val ){
			if( substr_count($val, 'background')>0 && substr_count($val, '#')>0 ){
				foreach( explode( ' ', $val ) as $val_exp ){
					if( substr_count($val_exp, '#')>0 ){
						$pix_bg_class = vc_shortcode_custom_css_class( $css ).'-pix';
						$pix_bg_color = $val_exp;
					}
				}
			}
		}		
	}
	
	$output .= '<div class="tooth-color-w '.$pix_bg_class.'">';
	if($pix_bg_class != ''){
		$output .= '
		<style scoped>
			.'.esc_attr($pix_bg_class).':before{
				z-index:77;
				background: linear-gradient(145deg, '.esc_attr($pix_bg_color).' 15px, transparent 0), linear-gradient(-145deg, '.esc_attr($pix_bg_color).' 15px, transparent 0);
				background-repeat: repeat-x;
				background-size: 30px 30px;
				content: " ";
				display: block;
				position: absolute;
				top: 0px;
				left: 0px;
				width: 100%;
				height: 25px;
				background-position: left-bottom;
				-webkit-transform: rotate(-180deg);
				-moz-transform: rotate(-180deg);
				transform: rotate(-180deg);				
			}
		</style>';
	}
	$output .= '</div>';
}
$output .= '</div>';

$output .= $after_output;
$output .= $this->endBlockComment( $this->getShortcode() );

echo $output;